/*
 * Decompiled with CFR 0.152.
 */
package dc.android.base.activity;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import dc.android.base.activity.SplashActivity;
import dc.android.bridge.R;
import dc.android.common.utils.OsUtils;
import dc.common.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

@Deprecated
public class BarActivity
extends SplashActivity {
    protected FrameLayout mFrameLayoutContent;
    protected View mViewStatusBarPlace;
    protected boolean FLAG_FULL;
    protected boolean FLAG_BAR_STATUS;
    protected boolean FLAG_BAR_NAV;
    private int barSource = R.layout.activity_bar;
    boolean isDark;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.FLAG_FULL) {
            this.setTheme(R.style.FullTheme);
        } else if (this.FLAG_BAR_STATUS) {
            super.setContentView(this.barSource);
            this.mViewStatusBarPlace = this.findViewById(R.id.view_status_bar_place);
            this.mFrameLayoutContent = (FrameLayout)this.findViewById(R.id.layout_frame_content_place);
            ViewGroup.LayoutParams params = this.mViewStatusBarPlace.getLayoutParams();
            params.height = this.getStatusBarHeight();
            this.mViewStatusBarPlace.setLayoutParams(params);
        }
    }

    public void setContentView(@LayoutRes int layoutResID) {
        if (this.FLAG_BAR_STATUS) {
            View contentView = LayoutInflater.from((Context)this).inflate(layoutResID, null);
            this.mFrameLayoutContent.addView(contentView);
        } else {
            super.setContentView(layoutResID);
        }
    }

    public void setImmersiveStatusBar(boolean fontIconDark, int statusBarPlaceColor) {
        this.setTranslucentStatus();
        this.isDark = false;
        if (fontIconDark) {
            Logger.w((String)(Build.VERSION.SDK_INT + "    " + 23));
            if (Build.VERSION.SDK_INT >= 23 || OsUtils.isMIUI() || OsUtils.isFlyme()) {
                this.setStatusBarFontIconDark(true);
            } else if (statusBarPlaceColor == -1 || statusBarPlaceColor == 0) {
                statusBarPlaceColor = -3355444;
            }
        }
        this.setStatusBarPlaceColor(statusBarPlaceColor);
    }

    private void setStatusBarPlaceColor(int statusColor) {
        if (this.mViewStatusBarPlace != null) {
            this.mViewStatusBarPlace.setBackgroundColor(statusColor);
        }
    }

    public int getStatusBarHeight() {
        int statusBarHeight = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = this.getResources().getDimensionPixelSize(resourceId);
        }
        Logger.w((String)("get status bar height is " + statusBarHeight));
        return statusBarHeight;
    }

    private void setTranslucentStatus() {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.clearFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(1280);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
        } else if (Build.VERSION.SDK_INT >= 19) {
            this.getWindow().addFlags(0x4000000);
        }
    }

    private void setStatusBarFontIconDark(boolean dark) {
        Window window;
        try {
            window = this.getWindow();
            Class<?> clazz = this.getWindow().getClass();
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            int darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            if (dark) {
                extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
            } else {
                extraFlagField.invoke((Object)window, 0, darkModeFlag);
            }
        }
        catch (Exception e) {
            Logger.w((String)e.getMessage());
        }
        try {
            window = this.getWindow();
            WindowManager.LayoutParams lp = window.getAttributes();
            Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
            darkFlag.setAccessible(true);
            meizuFlags.setAccessible(true);
            int bit = darkFlag.getInt(null);
            int value = meizuFlags.getInt(lp);
            value = dark ? (value |= bit) : (value &= ~bit);
            meizuFlags.setInt(lp, value);
            window.setAttributes(lp);
        }
        catch (Exception e) {
            Logger.w((String)e.getMessage());
        }
        Logger.w((String)(Build.VERSION.SDK_INT + "   " + 23 + "   " + dark));
        if (Build.VERSION.SDK_INT >= 23 && dark) {
            this.isDark = true;
            this.setBars();
        }
    }

    protected void setBars() {
        Logger.w((String)(this.isDark + "     " + this.FLAG_BAR_STATUS + "   " + this.FLAG_BAR_NAV));
        if (this.isDark && this.FLAG_BAR_STATUS && !this.FLAG_BAR_NAV) {
            this.getWindow().getDecorView().setSystemUiVisibility(13314);
        } else if (this.isDark && this.FLAG_BAR_STATUS && this.FLAG_BAR_NAV) {
            this.getWindow().getDecorView().setSystemUiVisibility(9216);
        } else if (!this.FLAG_BAR_NAV) {
            this.getWindow().getDecorView().setSystemUiVisibility(4098);
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        Logger.w((String)("this is on windows focus changed : " + hasFocus));
        if (!this.FLAG_BAR_NAV) {
            this.hiddenNav();
        }
    }

    public void hiddenNav() {
        if (Build.VERSION.SDK_INT > 11 && Build.VERSION.SDK_INT < 19) {
            View v = this.getWindow().getDecorView();
            v.setSystemUiVisibility(8);
        } else if (Build.VERSION.SDK_INT >= 19) {
            this.setBars();
        }
    }

    protected void setShowStatus(boolean isShow) {
        this.FLAG_BAR_STATUS = isShow;
    }

    protected void setShowStatus(boolean isShow, int bar) {
        this.FLAG_BAR_STATUS = isShow;
        this.barSource = bar;
    }

    protected void setShowNav(boolean isShow) {
        this.FLAG_BAR_NAV = isShow;
    }

    public void setShowFull(boolean isShow) {
        this.FLAG_FULL = isShow;
    }
}

