package dc.android.common.utils;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Movie;
import android.graphics.drawable.Drawable;
import android.support.annotation.ArrayRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.RawRes;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;

import static dc.android.common.BaseApplication.getContext;
import static dc.common.Global.EMPTY;

/**
 * wrap Resource
 *
 * @author senrsl
 * @ClassName: ResourceUtils
 * @Package: dc.android.common.utils
 * @CreateTime: 2020/6/9 6:19 PM
 */
public class ResourceUtils {

    /**
     * 取 res String
     *
     * @param resId
     * @return resString/""
     */
    public static String getString(@StringRes int resId) {

        try {
            return getContext().getString(resId);
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }

        return EMPTY;
    }

    /**
     * fmt str
     *
     * @param resId
     * @param args
     * @return
     */
    public static String getString(@StringRes int resId, Object... args) {

        try {
            return getContext().getString(resId, args);
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }

        return EMPTY;
    }

    /**
     * 取 res
     *
     * @param resId
     * @return
     */
    public static CharSequence getText(@StringRes int resId) {

        try {
            return getContext().getText(resId);
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }

        return EMPTY;
    }

    /**
     * 取 string arr
     *
     * @param resId
     * @return
     */
    public static String[] getStringArray(@ArrayRes int resId) {
        try {
            return getContext().getResources().getStringArray(resId);
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
        return new String[]{};
    }

    /**
     * 取 int arr
     *
     * @param resId
     * @return
     */
    public static int[] getIntArray(@ArrayRes int resId) {
        try {
            return getContext().getResources().getIntArray(resId);
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
        return new int[]{};
    }

    /**
     * 取 res Color
     *
     * @param resId
     * @return resColor/BLACK
     */
    @ColorInt
    public static int getColor(@ColorRes int resId) {

        try {
            return ContextCompat.getColor(getContext(), resId);
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }

        return Color.BLACK;
    }

    /**
     * 取 drawable
     * <p>
     * throw Resources.NotFoundException e
     *
     * @param resId
     * @return
     */
    public static Drawable getDrawable(@DrawableRes int resId) {
        return ContextCompat.getDrawable(getContext(), resId);
    }

    /**
     * 取 bitmap
     *
     * @param resId
     * @return
     */
    public static Bitmap getBitmap(int resId) {
        return BitmapFactory.decodeResource(getContext().getResources(), resId);
    }

    /**
     * 取 bitmap
     *
     * @param resPath
     * @return bitmap/null
     */
    public static Bitmap getBitmap(String resPath) {
        return BitmapFactory.decodeFile(resPath);
    }


    /**
     * 取 raw movie
     * <p>
     * throw Resources.NotFoundException e
     *
     * @param resId
     * @return
     */
    @SuppressWarnings("deprecation")
    public static Movie getMovie(@RawRes int resId) {
        return getContext().getResources().getMovie(resId);
    }

    /**
     * raw
     *
     * @return
     */
    public static AssetManager getAssets() {
        return getContext().getAssets();
        //return getContext().getResources().getAssets();
    }


}
