/*
 * Decompiled with CFR 0.152.
 */
package dc.android.common.utils;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Process;
import android.support.v4.app.ActivityOptionsCompat;
import android.support.v4.util.Pair;
import android.support.v4.view.ViewCompat;
import android.view.View;
import dc.android.common.BridgeContext;
import dc.common.Logger;

public class TaskUtils {
    private int startSingleFlags = 0x30008000;

    private static Class getClass(String path) {
        try {
            if (null != path && path.trim().length() > 0) {
                return Class.forName(path);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void startHome(Context ctx, int reason) {
        this.startSingleActivity(ctx, this.startSingleFlags, reason, TaskUtils.getClass(BridgeContext.CLS_HOME));
    }

    public void startHome(Context ctx, int flags, int reason) {
        this.startSingleActivity(ctx, flags, reason, TaskUtils.getClass(BridgeContext.CLS_HOME));
    }

    public void startLogin(Context ctx, int reason) {
        this.startSingleActivity(ctx, this.startSingleFlags, reason, TaskUtils.getClass(BridgeContext.CLS_LOGIN));
    }

    public void startLogin(Context ctx, int flags, int reason) {
        this.startSingleActivity(ctx, flags, reason, TaskUtils.getClass(BridgeContext.CLS_LOGIN));
    }

    public void startWelcome(Context ctx, int reason) {
        this.startSingleActivity(ctx, this.startSingleFlags, reason, TaskUtils.getClass(BridgeContext.CLS_WELCOME));
    }

    public void startSingleActivity(Context ctx, int flags, int reason, Class cls) {
        this.startSingleActivity(ctx, flags, reason, "", cls);
    }

    public void startSingleActivity(Context ctx, int flags, int reason, String bridge, Class cls) {
        if (null == cls) {
            return;
        }
        Intent intent = new Intent();
        intent.setClass(ctx, cls);
        intent.putExtra("logout", reason);
        intent.putExtra("bridge", bridge);
        intent.addFlags(flags);
        ctx.startActivity(intent);
    }

    public void startLauncher(Context ctx) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.setFlags(0x10000000);
        intent.addCategory("android.intent.category.HOME");
        ctx.startActivity(intent);
    }

    public void exit(Context ctx) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        intent.setFlags(0x10000000);
        ctx.startActivity(intent);
        TaskUtils.killProcess();
    }

    public static void restart(Context mContext) {
        try {
            Thread.sleep(1000L);
            Intent intent = new Intent(mContext, TaskUtils.getClass(BridgeContext.CLS_WELCOME));
            intent.addFlags(0x14000000);
            mContext.startActivity(intent);
        }
        catch (InterruptedException e) {
            Logger.w((String)e.getMessage());
        }
        TaskUtils.killProcess();
    }

    public static void killProcess() {
        Process.killProcess((int)Process.myPid());
        System.exit(0);
    }

    public void startExplodeActivity(View view, Activity activity, Intent intent) {
        if (Build.VERSION.SDK_INT >= 21) {
            Pair squareParticipant = new Pair((Object)view, (Object)ViewCompat.getTransitionName((View)view));
            ActivityOptionsCompat transitionActivityOptions = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)activity, (Pair[])new Pair[]{squareParticipant});
            activity.startActivity(intent, transitionActivityOptions.toBundle());
        } else {
            activity.startActivity(intent);
        }
    }

    public void startExplodeActivity(View view, Activity activity, Intent intent, String url) {
        if (Build.VERSION.SDK_INT >= 21) {
            ActivityOptionsCompat transitionActivityOptions = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)activity, (View)view, (String)url);
            activity.startActivity(intent, transitionActivityOptions.toBundle());
        } else {
            activity.startActivity(intent);
        }
    }

    public void startMarket(Context ctx, String marketName) throws ActivityNotFoundException {
        Intent intent = new Intent("android.intent.action.VIEW");
        Uri uri = Uri.parse((String)String.format("market://details?id=%s", ctx.getPackageName()));
        intent.setData(uri);
        intent.setPackage(marketName);
        ctx.startActivity(intent);
        Logger.w((Object[])new Object[]{this.getClass().getSimpleName(), ctx, marketName, uri});
    }
}

