/*
 * Decompiled with CFR 0.152.
 */
package dc.android.common.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import dc.android.common.BridgeContext;
import dc.android.common.utils.ScreenUtils;
import dc.common.Logger;

public class AutoMarginUtils {
    public static int displayWidth;
    public static int displayHeight;
    private static int designWidth;
    private static int designHeight;
    private static double textPixelsRate;

    public static void setSize(Context ctx, boolean hasStatusBar, int designWidth, int designHeight) {
        if (ctx == null || designWidth < 1 || designHeight < 1) {
            return;
        }
        Point point = ScreenUtils.getDisplayPoint((Context)ctx);
        int width = point.x;
        int height = point.y;
        Logger.w((String)("display  height is " + height + "  width is :" + width));
        if (hasStatusBar) {
            height -= AutoMarginUtils.getStatusBarHeight(ctx);
        }
        Logger.w((String)("height is " + height + "  width is :" + width));
        displayWidth = width;
        displayHeight = height;
        AutoMarginUtils.designWidth = designWidth;
        AutoMarginUtils.designHeight = designHeight;
        double displayDiagonal = Math.sqrt(Math.pow(displayWidth, 2.0) + Math.pow(displayHeight, 2.0));
        double designDiagonal = Math.sqrt(Math.pow(AutoMarginUtils.designWidth, 2.0) + Math.pow(AutoMarginUtils.designHeight, 2.0));
        textPixelsRate = displayDiagonal / designDiagonal;
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        try {
            int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
            if (resourceId > 0) {
                result = context.getResources().getDimensionPixelSize(resourceId);
            }
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
        Logger.w((String)("status bar height is : " + result));
        return result;
    }

    public static void auto(Activity act) {
        if (act == null || displayWidth < 1 || displayHeight < 1) {
            return;
        }
        View view = act.getWindow().getDecorView();
        AutoMarginUtils.auto(view);
    }

    public static void auto(View view) {
        if (view == null || displayWidth < 1 || displayHeight < 1) {
            return;
        }
        AutoMarginUtils.autoTextSize(view);
        AutoMarginUtils.autoSize(view);
        AutoMarginUtils.autoPadding(view);
        AutoMarginUtils.autoMargin(view);
        if (view instanceof ViewGroup) {
            AutoMarginUtils.auto((ViewGroup)view);
        }
    }

    private static void auto(ViewGroup viewGroup) {
        int count = viewGroup.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = viewGroup.getChildAt(i);
            if (child == null) continue;
            AutoMarginUtils.auto(child);
        }
    }

    public static void autoMargin(View view) {
        if (!(view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams)) {
            return;
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        if (lp == null) {
            return;
        }
        lp.leftMargin = AutoMarginUtils.getDisplayWidthValue(lp.leftMargin);
        lp.topMargin = AutoMarginUtils.getDisplayHeightValue(lp.topMargin);
        lp.rightMargin = AutoMarginUtils.getDisplayWidthValue(lp.rightMargin);
        lp.bottomMargin = AutoMarginUtils.getDisplayHeightValue(lp.bottomMargin);
    }

    public static void autoPadding(View view) {
        int l = view.getPaddingLeft();
        int t = view.getPaddingTop();
        int r = view.getPaddingRight();
        int b = view.getPaddingBottom();
        l = AutoMarginUtils.getDisplayWidthValue(l);
        t = AutoMarginUtils.getDisplayHeightValue(t);
        r = AutoMarginUtils.getDisplayWidthValue(r);
        b = AutoMarginUtils.getDisplayHeightValue(b);
        view.setPadding(l, t, r, b);
    }

    public static void autoSize(View view) {
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp == null) {
            return;
        }
        boolean isSquare = false;
        if (lp.width == lp.height) {
            isSquare = true;
        }
        if (lp.width > 0) {
            lp.width = AutoMarginUtils.getDisplayWidthValue(lp.width);
        }
        if (lp.height > 0) {
            lp.height = AutoMarginUtils.getDisplayHeightValue(lp.height);
        }
        if (isSquare) {
            if (lp.width > lp.height) {
                lp.width = lp.height;
            } else {
                lp.height = lp.width;
            }
        }
    }

    public static void autoTextSize(View view) {
        if (view instanceof TextView) {
            double designPixels = ((TextView)view).getTextSize();
            double displayPixels = textPixelsRate * designPixels;
            ((TextView)view).setIncludeFontPadding(false);
            ((TextView)view).setTextSize(0, (float)displayPixels);
        }
    }

    public static int getDisplayWidthValue(int designWidthValue) {
        if (Math.abs(designWidthValue) < 2) {
            return designWidthValue;
        }
        if (designWidth == 0) {
            designWidth = BridgeContext.DESIGN_WIDTH;
        }
        return designWidthValue * displayWidth / designWidth;
    }

    public static int getDisplayHeightValue(int designHeightValue) {
        if (Math.abs(designHeightValue) < 2) {
            return designHeightValue;
        }
        if (designHeight == 0) {
            designHeight = BridgeContext.DESIGN_HEIGHT;
        }
        return designHeightValue * displayHeight / designHeight;
    }

    public static float getDisplayTextSize(float designTextSize) {
        return (float)(textPixelsRate * (double)designTextSize);
    }

    public static double getTextPixelsRate() {
        return textPixelsRate == 0.0 ? 1.0 : textPixelsRate;
    }
}

