package dc.android.views;

import android.animation.Animator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import dc.android.common.utils.ImmersiveUtils;
import dc.android.common.utils.ScreenUtils;

/**
 * @author senrsl
 * @ClassName: RevealPopupWindow
 * @Package: dc.android.common.views
 * @CreateTime: 2018/12/28 3:36 PM
 */
public class RevealPopupWindow extends RelativePopupWindow {

    public RevealPopupWindow(Context context, View view) {
        super(context);
        setContentView(view);
        setWidth(ViewGroup.LayoutParams.WRAP_CONTENT);
        setHeight(ViewGroup.LayoutParams.WRAP_CONTENT);
        setFocusable(true); //关了这个，就不会调起虚拟导航栏了
        setOutsideTouchable(true);
        setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));

        // Disable default animation for circular reveal
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            setAnimationStyle(0);
        }
    }

    @Override
    public void showOnAnchor(@NonNull View anchor, int vertPos, int horizPos, int x, int y, boolean fitInScreen) {
        super.showOnAnchor(anchor, vertPos, horizPos, x, y, fitInScreen);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            circularReveal(anchor);
        }
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    private void circularReveal(@NonNull final View anchor) {
        final View contentView = getContentView();
        contentView.post(new Runnable() {
            @Override
            public void run() {
                final int[] myLocation = new int[2];
                final int[] anchorLocation = new int[2];
                contentView.getLocationOnScreen(myLocation);
                anchor.getLocationOnScreen(anchorLocation);
                final int cx = anchorLocation[0] - myLocation[0] + anchor.getWidth() / 2;
                final int cy = anchorLocation[1] - myLocation[1] + anchor.getHeight() / 2;

                contentView.measure(View.MeasureSpec.UNSPECIFIED, View.MeasureSpec.UNSPECIFIED);
                final int dx = Math.max(cx, contentView.getMeasuredWidth() - cx);
                final int dy = Math.max(cy, contentView.getMeasuredHeight() - cy);
                final float finalRadius = (float) Math.hypot(dx, dy);
                Animator animator = ViewAnimationUtils.createCircularReveal(contentView, cx, cy, 0f, finalRadius);
                animator.setDuration(500);
                animator.start();
            }
        });
    }

    public void setFocus(boolean isFoucus) {
        setFocusable(isFoucus);
        update();
    }

    /**
     * 减去 anchor 上面 跟 anchor的高度
     * 实际使用中，如果存在下面，应该再减去下面的高度，取可用实际高度
     * 或
     * 直接取下面覆盖控件的可见高度 例：
     * private int getBottomVisibleHeight() {
     * Rect rect = new Rect();
     * layoutBottom.getLocalVisibleRect(rect);
     * return rect.bottom;
     * }
     * 其中 layoutBottom为popup要覆盖的FrameLayout
     * 比各种高度相减更稳妥
     *
     * @param ctx
     * @param anchor
     * @return
     */
    public int getFixHeight(Context ctx, View anchor) {
        int windowHeight = ScreenUtils.getDisplayHeight(ctx);
        int[] location = new int[2];
        anchor.getLocationOnScreen(location);
        int viewHeight = anchor.getHeight();
        int y = windowHeight - viewHeight - location[1];
        // Logger.w("TEST", windowHeight + "   " + location[0] + "   " + location[1] + "  " + viewHeight + "   " + y);

//        popupWindow.setHeight(y - DensityUtils.px2dip(ctx, 49)); //49是下面的bar
        return y;
    }

    public void show(View anchor) {
        setFocus(false);

        //重写此
        showOnAnchor(anchor, RelativePopupWindow.VerticalPosition.BELOW, RelativePopupWindow.HorizontalPosition.CENTER, true);

        ImmersiveUtils.hiddenNav(getContentView());

        setFocus(true);
    }

}
