package dc.android.common.utils;

import android.view.View;

/**
 * 连续点击事件
 *
 * @author senrsl
 * @ClassName: OnClickListener
 * @Package: dc.android.common.utils
 * @CreateTime: 2019/8/16 10:57 AM
 */
public abstract class AbsClickListener implements View.OnClickListener {
    private long mLastClickTime;
    private long timeInterval = 1000L;

    public AbsClickListener() {

    }


    public AbsClickListener(long interval) {
        this.timeInterval = interval;
    }

    @Override
    public void onClick(View v) {
        long nowTime = System.currentTimeMillis();
        if (nowTime - mLastClickTime > timeInterval) {
            // 单次点击事件
            onSingleClick(v);
            mLastClickTime = nowTime;
        } else {
            // 快速点击事件
            onFastClick(v);
        }
    }

    protected abstract void onSingleClick(View v);

    protected abstract void onFastClick(View v);
}