package dc.android.base.activity;

import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import dc.android.base.wrapper.HideInputWrapper;
import dc.android.base.wrapper.ImmersiveBarWrapper;
import dc.android.base.wrapper.OrientationWrapper;
import dc.android.base.wrapper.SplashWrapper;
import dc.android.bridge.activity.BaseStructWrapperActivity;
import dc.android.common.BridgeOpcode;

/**
 * 项目应根据实际情况自定义重写此类
 * <p>
 * 此类
 * 仅为兼容此模式
 *
 * @author senrsl
 * @ClassName: BridgeActivity
 * @Package: dc.android.base.activity
 * @CreateTime: 2019/4/24 5:45 PM
 */
public class BridgeActivity extends BaseStructWrapperActivity {

    protected OrientationWrapper orientationWrapper;
    protected ImmersiveBarWrapper barWrapper;
    protected HideInputWrapper hideInputWrapper;


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        initWrapper();

        initOnCreate();
    }

    protected void initWrapper() {
        orientationWrapper = new OrientationWrapper(this);

        SplashWrapper splashWrapper = new SplashWrapper(this);
        splashWrapper.checkKeep();

        barWrapper = new ImmersiveBarWrapper(this);
        hideInputWrapper = new HideInputWrapper(this);
    }

    @Override
    protected void initLayout() {
        super.initLayout();
        if (null != orientationWrapper) orientationWrapper.onCreate();
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        return null == hideInputWrapper ? super.dispatchTouchEvent(ev) : hideInputWrapper.dispatchTouchEvent(ev);
    }


    protected void setLayout(boolean isShowStatus, @LayoutRes int layoutRes, boolean isStatusDark, @ColorInt int statusBarColor) {
        View view;
        if (BridgeOpcode.DEFAULT == layoutRes) view = new View(this);
        else view = LayoutInflater.from(this).inflate(layoutRes, null);

        setLayout(isShowStatus, view, isStatusDark, statusBarColor);
    }

    /**
     * 下放项目，自由组合，注意顺序
     *
     * @param isShowStatus
     * @param view
     * @param isStatusDark
     * @param statusBarColor
     */
    protected void setLayout(boolean isShowStatus, @NonNull View view, boolean isStatusDark, @ColorInt int statusBarColor) {
        if (null == barWrapper) return;
        barWrapper.setShowStatus(isShowStatus);
//        barWrapper.setShowNav(true);
//        barWrapper.setShowFull(true);
        barWrapper.onCreate();
        barWrapper.setContentView(view);
        barWrapper.setImmersiveStatusBar(isStatusDark, statusBarColor);
        //AutoMarginUtils.auto(barWrapper.getFrameLayoutContent());
    }

}
