/*
 * Decompiled with CFR 0.152.
 */
package dc.android.views;

import android.animation.Animator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewAnimationUtils;
import dc.android.common.utils.ImmersiveUtils;
import dc.android.common.utils.ScreenUtils;
import dc.android.views.RelativePopupWindow;

public class RevealPopupWindow
extends RelativePopupWindow {
    public RevealPopupWindow(Context context, View view) {
        super(context);
        this.setContentView(view);
        this.setWidth(-2);
        this.setHeight(-2);
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        if (Build.VERSION.SDK_INT >= 21) {
            this.setAnimationStyle(0);
        }
    }

    @Override
    public void showOnAnchor(@NonNull View anchor, int vertPos, int horizPos, int x, int y, boolean fitInScreen) {
        super.showOnAnchor(anchor, vertPos, horizPos, x, y, fitInScreen);
        if (Build.VERSION.SDK_INT >= 21) {
            this.circularReveal(anchor);
        }
    }

    @TargetApi(value=21)
    private void circularReveal(final @NonNull View anchor) {
        final View contentView = this.getContentView();
        contentView.post(new Runnable(){

            @Override
            public void run() {
                int[] myLocation = new int[2];
                int[] anchorLocation = new int[2];
                contentView.getLocationOnScreen(myLocation);
                anchor.getLocationOnScreen(anchorLocation);
                int cx = anchorLocation[0] - myLocation[0] + anchor.getWidth() / 2;
                int cy = anchorLocation[1] - myLocation[1] + anchor.getHeight() / 2;
                contentView.measure(0, 0);
                int dx = Math.max(cx, contentView.getMeasuredWidth() - cx);
                int dy = Math.max(cy, contentView.getMeasuredHeight() - cy);
                float finalRadius = (float)Math.hypot(dx, dy);
                Animator animator = ViewAnimationUtils.createCircularReveal((View)contentView, (int)cx, (int)cy, (float)0.0f, (float)finalRadius);
                animator.setDuration(500L);
                animator.start();
            }
        });
    }

    public void setFocus(boolean isFoucus) {
        this.setFocusable(isFoucus);
        this.update();
    }

    public int getFixHeight(Context ctx, View anchor) {
        int windowHeight = ScreenUtils.getDisplayHeight((Context)ctx);
        int[] location = new int[2];
        anchor.getLocationOnScreen(location);
        int viewHeight = anchor.getHeight();
        int y = windowHeight - viewHeight - location[1];
        return y;
    }

    public void show(View anchor) {
        this.setFocus(false);
        this.showOnAnchor(anchor, 2, 0, true);
        ImmersiveUtils.hiddenNav((View)this.getContentView());
        this.setFocus(true);
    }
}

