/*
 * Decompiled with CFR 0.152.
 */
package dc.android.views;

import android.app.Dialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import dc.android.bridge.R;
import dc.android.common.utils.ImmersiveUtils;

public class LoadingDialog {
    Context ctx;
    Dialog loadingDialog;
    TextView tipTextView;

    public LoadingDialog(Context context) {
        this.ctx = context;
        this.createLoadingDialog();
    }

    private Dialog createLoadingDialog() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.ctx);
        View v = inflater.inflate(R.layout.dialog_loading, null);
        LinearLayout layout2 = (LinearLayout)v.findViewById(R.id.layout_dialog_loading);
        this.tipTextView = (TextView)v.findViewById(R.id.tipTextView);
        this.loadingDialog = new Dialog(this.ctx, R.style.DialogLoadingStyle);
        this.loadingDialog.setCancelable(true);
        this.loadingDialog.setCanceledOnTouchOutside(false);
        this.loadingDialog.setContentView((View)layout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        Window window = this.loadingDialog.getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.width = -1;
        lp.height = -2;
        window.setGravity(17);
        window.setAttributes(lp);
        window.setWindowAnimations(R.style.DialogLoadingAnimation);
        return this.loadingDialog;
    }

    public void setTips(int tips) {
        this.tipTextView.setText(tips);
    }

    public void showDialog() {
        this.showDialog(null);
    }

    public void showDialog(String msg) {
        if (null != msg && null != this.tipTextView) {
            this.tipTextView.setText((CharSequence)msg);
        }
        if (null != this.loadingDialog) {
            this.loadingDialog.getWindow().setFlags(8, 8);
            this.loadingDialog.show();
            ImmersiveUtils.hiddenNav((View)this.loadingDialog.getWindow().getDecorView());
            this.loadingDialog.getWindow().clearFlags(8);
        }
    }

    public void dismissDialog() {
        if (null != this.loadingDialog && this.loadingDialog.isShowing()) {
            this.loadingDialog.dismiss();
        }
    }
}

