/*
 * Decompiled with CFR 0.152.
 */
package dc.android.common.handler;

import android.content.Context;
import android.os.Looper;
import dc.android.bridge.R;
import dc.android.common.BridgeContext;
import dc.android.common.utils.SharePreferencesUtils;
import dc.android.common.utils.TaskUtils;
import dc.android.common.utils.ThrowableUtils;
import dc.common.Logger;
import dc.common.utils.StringUtils;
import java.util.Date;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private static CrashHandler INSTANCE = new CrashHandler();
    private Context ctx;
    private Callback cb;
    private long initTime;

    private CrashHandler() {
    }

    public static CrashHandler getInstance() {
        return INSTANCE;
    }

    public void init(Context context) {
        this.init(context, null);
    }

    public void init(Context context, Callback cb) {
        this.ctx = context;
        this.cb = cb;
        this.initTime = this.getCurrentTime();
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (!this.handleException(ex) && this.mDefaultHandler != null) {
            this.mDefaultHandler.uncaughtException(thread, ex);
        } else {
            TaskUtils.restart(this.ctx);
        }
    }

    private boolean handleException(Throwable ex) {
        if (ex == null) {
            return false;
        }
        this.showRestartTips();
        String info = ThrowableUtils.getInfo(ex);
        this.saveCrashInfo2File(info);
        this.log2Fabric(ex, info);
        return true;
    }

    private void showRestartTips() {
        String tips = this.ctx.getString(R.string.restart);
        if (StringUtils.isEmpty((String)tips)) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                Looper.prepare();
                Logger.w((Context)CrashHandler.this.ctx, (String)CrashHandler.this.ctx.getString(R.string.restart));
                Looper.loop();
            }
        }.start();
    }

    private void saveCrashInfo2File(String s) {
        if (s.length() > BridgeContext.CRASH_INFO_MAX) {
            s = s.substring(0, BridgeContext.CRASH_INFO_MAX);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTime(this.initTime)).append(BridgeContext.TAB);
        sb.append(this.getTime(this.getCurrentTime())).append(BridgeContext.TAB);
        sb.append(this.getCurrentTime() - this.initTime).append(BridgeContext.LINE);
        sb.append(s);
        new SharePreferencesUtils(this.ctx).saveSharedPreferencesValue("isCrash", sb.toString());
    }

    private void log2Fabric(Throwable ex, String info) {
        if (null != this.cb) {
            this.cb.onFabric(ex, info);
        }
    }

    private String getTime(long timestamp) {
        return new Date(timestamp).toString();
    }

    private long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public static interface Callback {
        public void onFabric(Throwable var1, String var2);
    }
}

