/*
 * Decompiled with CFR 0.152.
 */
package dc.android.bridge.fragment;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import dc.android.common.activity.BaseActivity;

public class BaseFragment<T extends BaseActivity>
extends Fragment {
    protected T activity;

    public void onAttach(Context context) {
        super.onAttach(context);
        this.onAttachToContext(context);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (Build.VERSION.SDK_INT < 23) {
            this.onAttachToContext((Context)activity);
        }
    }

    protected void onAttachToContext(Context context) {
        this.activity = (BaseActivity)this.getActivity();
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        try {
            this.inflatView();
            this.initData();
            this.initAttach();
            this.refreshDataOnCreated();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void inflatView() {
    }

    protected void initData() {
    }

    protected void initAttach() {
    }

    public void onStart() {
        super.onStart();
        if (null == this.activity) {
            this.activity = (BaseActivity)this.getActivity();
        }
    }

    public void onResume() {
        super.onResume();
        try {
            this.refreshDataOnVisible();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (!hidden) {
            this.refreshDataOnVisible();
        }
    }

    protected void loadData() {
        this.refreshData();
    }

    public void refreshDataOnCreated() {
    }

    protected void refreshDataOnVisible() {
    }

    public void refreshDataOnRequest() {
    }

    public void refreshData() {
    }

    protected boolean isAvailable() {
        return null != this.activity && this.isAdded();
    }
}

