/*
 * Decompiled with CFR 0.152.
 */
package dc.android.base.wrapper;

import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import dc.android.common.activity.BaseActivity;
import dc.android.common.utils.ImmersiveUtils;

public class HideInputWrapper {
    private BaseActivity activity;

    public HideInputWrapper(BaseActivity activity) {
        this.activity = activity;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            if (this.dontHideInput(ev) && this.isShouldHideInput(this.activity.getCurrentFocus(), ev)) {
                this.hideSoftInput();
            }
            return this.dispatchTouchEventSuper(ev);
        }
        if (this.activity.getWindow().superDispatchTouchEvent(ev)) {
            return true;
        }
        return this.activity.onTouchEvent(ev);
    }

    public boolean dispatchTouchEventSuper(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.activity.onUserInteraction();
        }
        if (this.activity.getWindow().superDispatchTouchEvent(ev)) {
            return true;
        }
        return this.activity.onTouchEvent(ev);
    }

    protected void hideSoftInput() {
        InputMethodManager imm = (InputMethodManager)this.activity.getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.activity.getCurrentFocus().getWindowToken(), 0);
            ImmersiveUtils.hiddenNav((View)this.activity.getWindow().getDecorView());
        }
    }

    private boolean isShouldHideInput(View v, MotionEvent event) {
        if (v != null && v instanceof EditText) {
            int[] leftTop = new int[]{0, 0};
            v.getLocationInWindow(leftTop);
            int left = leftTop[0];
            int top = leftTop[1];
            int bottom = top + v.getHeight();
            int right = left + v.getWidth();
            return !(event.getX() > (float)left) || !(event.getX() < (float)right) || !(event.getY() > (float)top) || !(event.getY() < (float)bottom);
        }
        return false;
    }

    protected boolean dontHideInput(MotionEvent ev) {
        return true;
    }

    protected boolean isTouchPointInView(View view, MotionEvent ev) {
        if (view == null) {
            return false;
        }
        int x = (int)ev.getRawX();
        int y = (int)ev.getRawY();
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int left = location[0];
        int top = location[1];
        int right = left + view.getMeasuredWidth();
        int bottom = top + view.getMeasuredHeight();
        return y >= top && y <= bottom && x >= left && x <= right;
    }
}

