package dc.android.views;


import android.app.Dialog;
import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import dc.android.bridge.R;
import dc.android.common.utils.ImmersiveUtils;

/**
 * @author senrsl
 * @ClassName: LoadingDialog
 * @Package: dc.android.common.views
 * @CreateTime: 2018/5/28 下午2:01
 */
public class LoadingDialog {

    Context ctx;
    Dialog loadingDialog;

    TextView tipTextView;

    public LoadingDialog(Context context) {
        this.ctx = context;
        createLoadingDialog();
    }


    private Dialog createLoadingDialog() {
        LayoutInflater inflater = LayoutInflater.from(ctx);
        View v = inflater.inflate(R.layout.dialog_loading, null);// 得到加载view
        LinearLayout layout = v
                .findViewById(R.id.layout_dialog_loading);// 加载布局
        tipTextView = v.findViewById(R.id.tipTextView);// 提示文字

        loadingDialog = new Dialog(ctx, R.style.DialogLoadingStyle);// 创建自定义样式dialog
        loadingDialog.setCancelable(true); // 是否可以按“返回键”消失
        loadingDialog.setCanceledOnTouchOutside(false); // 点击加载框以外的区域
        loadingDialog.setContentView(layout, new LinearLayout.LayoutParams(
                LinearLayout.LayoutParams.MATCH_PARENT,
                LinearLayout.LayoutParams.MATCH_PARENT));// 设置布局
        /**
         *将显示Dialog的方法封装在这里面
         */
        Window window = loadingDialog.getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        window.setGravity(Gravity.CENTER);
        window.setAttributes(lp);
        window.setWindowAnimations(R.style.DialogLoadingAnimation);


        return loadingDialog;
    }

    public void setTips(int tips) {
        tipTextView.setText(tips);
    }

    public void showDialog() {
        showDialog(null);
    }

    public void showDialog(String msg) {
        if (null != msg && null != tipTextView) tipTextView.setText(msg);// 设置加载信息
        if (null != loadingDialog) {
            // Dialog 在初始化时会生成新的 Window，先禁止 Dialog Window 获取焦点，等 Dialog 显示后对 Dialog Window 的 DecorView 设置 setSystemUiVisibility ，接着再获取焦点。 这样表面上看起来就没有退出沉浸模式。
            // Set the dialog to not focusable (makes navigation ignore us adding the window)
            loadingDialog.getWindow().setFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);

            loadingDialog.show();

            ImmersiveUtils.hiddenNav(loadingDialog.getWindow().getDecorView());

            //Clear the not focusable flag from the window
            loadingDialog.getWindow().clearFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
        }
    }

    /**
     * 关闭dialog
     */
    public void dismissDialog() {
        if (null != loadingDialog && loadingDialog.isShowing()) {
            loadingDialog.dismiss();
        }
    }
}
