package dc.android.common.utils;

import android.support.annotation.NonNull;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import dc.android.bridge.fragment.BaseFragment;

/**
 * @author senrsl
 * @ClassName: FragmentUtils
 * @Package: dc.android.common.utils
 * @CreateTime: 2019/1/25 4:11 PM
 */
public class FragmentUtils {

    public static void addFragment(@NonNull FragmentManager fragmentManager, int layout, @NonNull BaseFragment fragment) {
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.add(layout, fragment);
        fragmentTransaction.commit();
    }

    public static void replaceFragment(@NonNull FragmentManager fragmentManager, int layout, @NonNull BaseFragment fragment) {
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.replace(layout, fragment);
        fragmentTransaction.commit();
    }

    public static void removeFragment(@NonNull FragmentManager fragmentManager, @NonNull BaseFragment fragment) {
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.remove(fragment);
        fragmentTransaction.commit();
    }

}
