package dc.android.base.activity;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import dc.android.bridge.R;
import dc.android.common.utils.OsUtils;
import dc.common.Logger;

/**
 * 伪沉浸式导航栏：<br/>
 *
 * @author senrsl
 * @ClassName: BarActivity
 * @Package: dc.android.base.activity
 * @CreateTime: 2018/6/4 上午11:47
 */
@Deprecated
public class BarActivity extends SplashActivity {
    protected FrameLayout mFrameLayoutContent;
    protected View mViewStatusBarPlace;

    protected boolean FLAG_FULL;
    protected boolean FLAG_BAR_STATUS;
    protected boolean FLAG_BAR_NAV;

    private int barSource = R.layout.activity_bar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (FLAG_FULL) {
            setTheme(R.style.FullTheme);
        } else if (FLAG_BAR_STATUS) {
            super.setContentView(barSource);

            mViewStatusBarPlace = findViewById(R.id.view_status_bar_place);
            mFrameLayoutContent = findViewById(R.id.layout_frame_content_place);

            ViewGroup.LayoutParams params = mViewStatusBarPlace.getLayoutParams();
            params.height = getStatusBarHeight();//注掉这里，bar布局使用px，即可使用autoMargin托管全页面，否则应只托管mFrame
            mViewStatusBarPlace.setLayoutParams(params);
        } else {
            //既非全屏，亦非自定状态栏
        }
    }


    @Override
    public void setContentView(@LayoutRes int layoutResID) {
        if (FLAG_BAR_STATUS) {
            View contentView = LayoutInflater.from(this).inflate(layoutResID, null);
            mFrameLayoutContent.addView(contentView);
        } else {
            super.setContentView(layoutResID);
        }
    }

    /**
     * 需要重写此方法<br/>
     * 白色：setImmersiveStatusBar(true, color);<br/>
     * 其他色：setImmersiveStatusBar(false, color);<br/>
     * 设置沉浸式状态栏
     *
     * @param fontIconDark 状态栏字体和图标颜色是否为深色
     */
    public void setImmersiveStatusBar(boolean fontIconDark, int statusBarPlaceColor) {
        setTranslucentStatus();
        isDark = false;
        if (fontIconDark) {
            Logger.w(Build.VERSION.SDK_INT + "    " + Build.VERSION_CODES.M);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M
                    || OsUtils.isMIUI()
                    || OsUtils.isFlyme()) {
                setStatusBarFontIconDark(true);
            } else {
                if (statusBarPlaceColor == Color.WHITE || statusBarPlaceColor == Color.TRANSPARENT) {
                    statusBarPlaceColor = 0xffcccccc;
                }
            }
        }
        setStatusBarPlaceColor(statusBarPlaceColor);
    }

    private void setStatusBarPlaceColor(int statusColor) {
        if (mViewStatusBarPlace != null) {
            mViewStatusBarPlace.setBackgroundColor(statusColor);
        }
    }

    public int getStatusBarHeight() {
        int statusBarHeight = 0;
        int resourceId = getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = getResources().getDimensionPixelSize(resourceId);
        }
        Logger.w("get status bar height is " + statusBarHeight);
        return statusBarHeight;
    }

    /**
     * 设置状态栏透明
     */
    private void setTranslucentStatus() {

        // 5.0以上系统状态栏透明
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Window window = getWindow();
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                    | View.SYSTEM_UI_FLAG_LAYOUT_STABLE);
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.setStatusBarColor(Color.TRANSPARENT);
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            getWindow().addFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
        }
    }

    /**
     * 设置Android状态栏的字体颜色，状态栏为亮色的时候字体和图标是黑色，状态栏为暗色的时候字体和图标为白色
     *
     * @param dark 状态栏字体是否为深色
     */
    private void setStatusBarFontIconDark(boolean dark) {
        // 小米MIUI
        try {
            Window window = getWindow();
            Class clazz = getWindow().getClass();
            Class layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            int darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", int.class, int.class);
            if (dark) {    //状态栏亮色且黑色字体
                extraFlagField.invoke(window, darkModeFlag, darkModeFlag);
            } else {       //清除黑色字体
                extraFlagField.invoke(window, 0, darkModeFlag);
            }
        } catch (Exception e) {
//            e.printStackTrace();
            Logger.w(e.getMessage());
        }

        // 魅族FlymeUI
        try {
            Window window = getWindow();
            WindowManager.LayoutParams lp = window.getAttributes();
            Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
            darkFlag.setAccessible(true);
            meizuFlags.setAccessible(true);
            int bit = darkFlag.getInt(null);
            int value = meizuFlags.getInt(lp);
            if (dark) {
                value |= bit;
            } else {
                value &= ~bit;
            }
            meizuFlags.setInt(lp, value);
            window.setAttributes(lp);
        } catch (Exception e) {
//            e.printStackTrace();
            Logger.w(e.getMessage());
        }
        // android6.0+系统
        // 这个设置和在xml的style文件中用这个<item name="android:windowLightStatusBar">true</item>属性是一样的
        Logger.w(Build.VERSION.SDK_INT + "   " + Build.VERSION_CODES.M + "   " + dark);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            if (dark) {
                //规避StatusBar与NavBar冲突问题
                isDark = true;
                setBars();
            }
        }
    }

    boolean isDark;

    protected void setBars() {
        Logger.w(isDark + "     " + FLAG_BAR_STATUS + "   " + FLAG_BAR_NAV);
        if (isDark && FLAG_BAR_STATUS && !FLAG_BAR_NAV) {
            getWindow().getDecorView().setSystemUiVisibility(
                    View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                            | View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
                            | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                            | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
        } else if (isDark && FLAG_BAR_STATUS && FLAG_BAR_NAV) {
            getWindow().getDecorView().setSystemUiVisibility(
                    View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                            | View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
        } else if (!FLAG_BAR_NAV) {
            getWindow().getDecorView().setSystemUiVisibility(
                    View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                            | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
        }
    }


    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        Logger.w("this is on windows focus changed : " + hasFocus);
        if (!FLAG_BAR_NAV) hiddenNav();
    }

    public void hiddenNav() {
        //隐藏虚拟按键，并且全屏
        if (Build.VERSION.SDK_INT > 11 && Build.VERSION.SDK_INT < 19) { // lower api
            View v = this.getWindow().getDecorView();
            v.setSystemUiVisibility(View.GONE);
        } else if (Build.VERSION.SDK_INT >= 19) {
            //for new api versions.
            setBars();
        }
    }

    protected void setShowStatus(boolean isShow) {
        this.FLAG_BAR_STATUS = isShow;
    }

    protected void setShowStatus(boolean isShow, int bar) {
        this.FLAG_BAR_STATUS = isShow;
        this.barSource = bar;
    }

    //    protected void setShowStatus(boolean fontIconDark, int statusBarPlaceColor){
//        this.FLAG_BAR_STATUS = true;
//        setImmersiveStatusBar(fontIconDark,statusBarPlaceColor);
//    }
    protected void setShowNav(boolean isShow) {
        this.FLAG_BAR_NAV = isShow;
    }

    public void setShowFull(boolean isShow) {
        this.FLAG_FULL = isShow;
    }
}