/*
 * Decompiled with CFR 0.152.
 */
package trujillo.david.bluetoothle.interfaces;

import android.bluetooth.BluetoothAdapter;
import android.os.Handler;
import android.os.Looper;
import trujillo.david.bluetoothle.BleBluetooth;

public abstract class PeriodScanCallback
implements BluetoothAdapter.LeScanCallback {
    private Handler handler = new Handler(Looper.getMainLooper());
    private long timeoutMillis = 10000L;
    BleBluetooth bleBluetooth;

    PeriodScanCallback(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public abstract void onScanTimeout();

    public abstract void onScanCancel();

    public void notifyScanStarted() {
        if (this.timeoutMillis > 0L) {
            this.removeHandlerMsg();
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PeriodScanCallback.this.bleBluetooth.stopScan(PeriodScanCallback.this);
                    PeriodScanCallback.this.onScanTimeout();
                }
            }, this.timeoutMillis);
        }
    }

    public void notifyScanCancel() {
        if (this.bleBluetooth != null) {
            this.bleBluetooth.stopScan(this);
            this.onScanCancel();
        }
    }

    public void removeHandlerMsg() {
        this.handler.removeCallbacksAndMessages(null);
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public PeriodScanCallback setTimeoutMillis(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public BleBluetooth getBleBluetooth() {
        return this.bleBluetooth;
    }

    public PeriodScanCallback setBleBluetooth(BleBluetooth bluetooth) {
        this.bleBluetooth = bluetooth;
        return this;
    }
}

