/*
 * Decompiled with CFR 0.152.
 */
package trujillo.david.bluetoothle.interfaces;

import android.bluetooth.BluetoothDevice;
import android.text.TextUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import trujillo.david.bluetoothle.interfaces.PeriodScanCallback;
import trujillo.david.bluetoothle.models.ScanResult;

public abstract class NameScanCallback
extends PeriodScanCallback {
    private String mName = null;
    private String[] mNames = null;
    private boolean mFuzzy = false;
    private AtomicBoolean hasFound = new AtomicBoolean(false);

    public NameScanCallback(String name, long timeoutMillis, boolean fuzzy) {
        super(timeoutMillis);
        this.mName = name;
        this.mFuzzy = fuzzy;
        if (TextUtils.isEmpty((CharSequence)name)) {
            this.onDeviceNotFound();
        }
    }

    public NameScanCallback(String[] names, long timeoutMillis, boolean fuzzy) {
        super(timeoutMillis);
        this.mNames = names;
        this.mFuzzy = fuzzy;
        if (names == null || names.length < 1) {
            this.onDeviceNotFound();
        }
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (device == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)device.getName())) {
            return;
        }
        if (!this.hasFound.get()) {
            ScanResult scanResult = new ScanResult(device, rssi, scanRecord, System.currentTimeMillis());
            if (this.mName != null) {
                if (this.mFuzzy ? device.getName().contains(this.mName) : this.mName.equalsIgnoreCase(device.getName())) {
                    this.hasFound.set(true);
                    this.bleBluetooth.stopScan(this);
                    this.onDeviceFound(scanResult);
                }
            } else if (this.mNames != null) {
                for (String name : this.mNames) {
                    if (!(this.mFuzzy ? device.getName().contains(name) : name.equalsIgnoreCase(device.getName()))) continue;
                    this.hasFound.set(true);
                    this.bleBluetooth.stopScan(this);
                    this.onDeviceFound(scanResult);
                    return;
                }
            }
        }
    }

    @Override
    public void onScanTimeout() {
        this.onDeviceNotFound();
    }

    @Override
    public void onScanCancel() {
    }

    public abstract void onDeviceFound(ScanResult var1);

    public abstract void onDeviceNotFound();
}

