/*
 * Decompiled with CFR 0.152.
 */
package trujillo.david.bluetoothle.interfaces;

import trujillo.david.bluetoothle.exceptions.BleException;
import trujillo.david.bluetoothle.exceptions.ConnectException;
import trujillo.david.bluetoothle.exceptions.GattException;
import trujillo.david.bluetoothle.exceptions.InitiatedException;
import trujillo.david.bluetoothle.exceptions.OtherException;
import trujillo.david.bluetoothle.exceptions.TimeoutException;

public abstract class BleExceptionHandler {
    public BleExceptionHandler handleException(BleException exception) {
        if (exception != null) {
            if (exception instanceof ConnectException) {
                this.onConnectException((ConnectException)exception);
            } else if (exception instanceof GattException) {
                this.onGattException((GattException)exception);
            } else if (exception instanceof TimeoutException) {
                this.onTimeoutException((TimeoutException)exception);
            } else if (exception instanceof InitiatedException) {
                this.onInitiatedException((InitiatedException)exception);
            } else {
                this.onOtherException((OtherException)exception);
            }
        }
        return this;
    }

    protected abstract void onConnectException(ConnectException var1);

    protected abstract void onGattException(GattException var1);

    protected abstract void onTimeoutException(TimeoutException var1);

    protected abstract void onInitiatedException(InitiatedException var1);

    protected abstract void onOtherException(OtherException var1);
}

