/*
 * Decompiled with CFR 0.152.
 */
package trujillo.david.bluetoothle;

import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.util.Log;
import trujillo.david.bluetoothle.BleManager;
import trujillo.david.bluetoothle.exceptions.BleException;
import trujillo.david.bluetoothle.interfaces.BleCharacterCallback;
import trujillo.david.bluetoothle.interfaces.BleGattCallback;
import trujillo.david.bluetoothle.interfaces.ConnectCallback;
import trujillo.david.bluetoothle.interfaces.ListScanCallback;
import trujillo.david.bluetoothle.models.ScanResult;
import trujillo.david.bluetoothle.utils.HexUtil;

public class BluetoothService
extends Service {
    public BluetoothBinder mBinder = new BluetoothBinder();
    private BleManager bleManager;
    private Handler threadHandler = new Handler(Looper.getMainLooper());
    private Callback mCallback = null;
    private static long TIME_OUT = 5000L;
    private String name;
    private String mac;
    private BluetoothGatt gatt;
    private BluetoothGattService service;
    private BluetoothGattCharacteristic characteristic;
    BleGattCallback bleGattCallback = new BleGattCallback(){

        @Override
        public void onNotFoundDevice() {
            BluetoothService.this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothService.this.mCallback != null) {
                        BluetoothService.this.mCallback.onConnectFail();
                    }
                }
            });
        }

        @Override
        public void onFoundDevice(ScanResult scanResult) {
            BluetoothService.this.name = scanResult.getDevice().getName();
            BluetoothService.this.mac = scanResult.getDevice().getAddress();
        }

        @Override
        public void onConnectSuccess(BluetoothGatt gatt, int status) {
            gatt.discoverServices();
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            BluetoothService.this.gatt = gatt;
            BluetoothService.this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothService.this.mCallback != null) {
                        BluetoothService.this.mCallback.onServicesDiscovered();
                    }
                }
            });
        }

        @Override
        public void onConnectFailure(BleException exception) {
            Log.d((String)"FAIL CONNECT", (String)"TRUE");
            BluetoothService.this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothService.this.mCallback != null) {
                        BluetoothService.this.mCallback.onConnectFail();
                        BluetoothService.this.mCallback.onDisConnected();
                    }
                }
            });
        }
    };
    BleGattCallback bleGattCallbackByName = new BleGattCallback(){

        @Override
        public void onNotFoundDevice() {
            BluetoothService.this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothService.this.mCallback != null) {
                        BluetoothService.this.mCallback.onConnectFail();
                    }
                }
            });
        }

        @Override
        public void onFoundDevice(ScanResult scanResult) {
            BluetoothService.this.name = scanResult.getDevice().getName();
            BluetoothService.this.mac = scanResult.getDevice().getAddress();
        }

        @Override
        public void onConnectSuccess(BluetoothGatt gatt, int status) {
            gatt.discoverServices();
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            BluetoothService.this.gatt = gatt;
            BluetoothService.this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothService.this.mCallback != null) {
                        BluetoothService.this.mCallback.onServicesDiscovered();
                    }
                }
            });
        }

        @Override
        public void onConnectFailure(BleException exception) {
            BluetoothService.this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothService.this.mCallback != null) {
                        BluetoothService.this.mCallback.onConnectFail();
                        BluetoothService.this.mCallback.onDisConnected();
                    }
                }
            });
        }
    };

    public void onCreate() {
        this.bleManager = new BleManager((Context)this);
        this.bleManager.enableBluetooth();
    }

    public void onDestroy() {
        super.onDestroy();
        this.bleManager = null;
        this.mCallback = null;
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public boolean onUnbind(Intent intent) {
        this.bleManager.closeBluetoothGatt();
        return super.onUnbind(intent);
    }

    public void setScanCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setTimeOut(long timeOut) {
        TIME_OUT = timeOut;
    }

    public void scanDevice() {
        boolean b;
        this.resetInfo();
        if (this.mCallback != null) {
            this.mCallback.onStartScan();
        }
        if (this.bleManager != null && !(b = this.bleManager.scanDevice(new ListScanCallback(TIME_OUT){

            @Override
            public void onScanning(final ScanResult result) {
                BluetoothService.this.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (BluetoothService.this.mCallback != null) {
                            BluetoothService.this.mCallback.onScanning(result);
                        }
                    }
                });
            }

            @Override
            public void onScanComplete(ScanResult[] results) {
                BluetoothService.this.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (BluetoothService.this.mCallback != null) {
                            BluetoothService.this.mCallback.onScanComplete();
                        }
                    }
                });
            }
        })) && this.mCallback != null) {
            this.mCallback.onScanComplete();
        }
    }

    public void scanAndConnectDevice(String name, boolean autoConnect, ConnectCallback connectCallback) {
        block3: {
            this.resetInfo();
            if (this.mCallback != null) {
                this.mCallback.onStartScan();
            }
            try {
                boolean bl = this.bleManager.scanNameAndConnect(name, TIME_OUT, autoConnect, this.bleGattCallbackByName);
            }
            catch (Exception e) {
                if (this.bleManager != null) break block3;
                this.bleManager = new BleManager((Context)this);
                boolean bl = this.bleManager.scanNameAndConnect(name, TIME_OUT, autoConnect, this.bleGattCallbackByName);
            }
        }
    }

    public void scanAndConnectDeviceDFU(String name, Long timeout, BleGattCallback bleGattCallbackByName) {
        this.resetInfo();
        if (this.mCallback != null) {
            this.mCallback.onStartScan();
        }
        boolean b = this.bleManager.scanNameAndConnect(name, timeout, true, bleGattCallbackByName);
    }

    public void scanAndConnectDeviceMac(String mac, ConnectCallback connectCallback) {
        this.resetInfo();
        if (this.mCallback != null) {
            this.mCallback.onStartScan();
        }
        boolean b = this.bleManager.scanMacAndConnect(mac, TIME_OUT, true, this.bleGattCallbackByName);
    }

    public void cancelScan() {
        if (this.bleManager != null) {
            this.bleManager.cancelScan();
        }
    }

    public void connectDevice(ScanResult scanResult, Boolean autoConnect) {
        if (this.mCallback != null) {
            this.mCallback.onConnecting();
        }
        if (this.bleManager.isConnectingOrConnected()) {
            this.bleManager.closeBluetoothGatt();
        }
        this.bleManager.connectDevice(scanResult, autoConnect, this.bleGattCallback);
    }

    public void read(String uuid_service, String uuid_read, BleCharacterCallback callback) {
        this.bleManager.readDevice(uuid_service, uuid_read, callback);
    }

    public void write(String uuid_service, String uuid_write, String hex, BleCharacterCallback callback) {
        if (this.bleManager != null) {
            this.bleManager.writeDevice(uuid_service, uuid_write, HexUtil.hexStringToBytes(hex), callback);
        }
    }

    public void notify(String uuid_service, String uuid_notify, BleCharacterCallback callback) {
        if (this.bleManager != null) {
            this.bleManager.notify(uuid_service, uuid_notify, callback);
        }
    }

    public void indicate(String uuid_service, String uuid_indicate, BleCharacterCallback callback) {
        this.bleManager.indicate(uuid_service, uuid_indicate, callback);
    }

    public void stopNotify(String uuid_service, String uuid_notify) {
        this.bleManager.stopNotify(uuid_service, uuid_notify);
    }

    public void stopIndicate(String uuid_service, String uuid_indicate) {
        this.bleManager.stopIndicate(uuid_service, uuid_indicate);
    }

    public void closeConnect() {
        if (this.bleManager != null) {
            this.bleManager.closeBluetoothGatt();
        }
        if (this.mCallback != null) {
            this.mCallback.onDisConnected();
        }
    }

    public void enableBluetooth() {
        this.bleManager.enableBluetooth();
    }

    private void resetInfo() {
        this.name = null;
        this.mac = null;
        this.gatt = null;
        this.service = null;
        this.characteristic = null;
    }

    public String getName() {
        return this.name;
    }

    public String getMac() {
        return this.mac;
    }

    public BluetoothGatt getGatt() {
        return this.gatt;
    }

    public BluetoothAdapter getAdapter() {
        return this.bleManager.getAdapter();
    }

    public void setService(BluetoothGattService service) {
        this.service = service;
    }

    public BluetoothGattService getService() {
        return this.service;
    }

    public void setCharacteristic(BluetoothGattCharacteristic characteristic) {
        this.characteristic = characteristic;
    }

    public BluetoothGattCharacteristic getCharacteristic() {
        return this.characteristic;
    }

    public void refreshDeviceCache() {
        try {
            if (this.bleManager != null) {
                this.bleManager.refreshDeviceCache();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runOnMainThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            this.threadHandler.post(runnable);
        }
    }

    public static interface Callback {
        public void onStartScan();

        public void onScanning(ScanResult var1);

        public void onScanComplete();

        public void onConnecting();

        public void onConnectFail();

        public void onDisConnected();

        public void onServicesDiscovered();
    }

    public class BluetoothBinder
    extends Binder {
        public BluetoothService getService() {
            return BluetoothService.this;
        }
    }
}

