/*
 * Decompiled with CFR 0.152.
 */
package trujillo.david.bluetoothle;

import android.app.Application;
import android.bluetooth.BluetoothGattCharacteristic;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import trujillo.david.bluetoothle.BluetoothService;
import trujillo.david.bluetoothle.ReaderManager;
import trujillo.david.bluetoothle.exceptions.BleException;
import trujillo.david.bluetoothle.interfaces.BleCharacterCallback;
import trujillo.david.bluetoothle.interfaces.BleGattCallback;
import trujillo.david.bluetoothle.interfaces.ConnectCallback;
import trujillo.david.bluetoothle.interfaces.ScanCallback;
import trujillo.david.bluetoothle.interfaces.ServiceCallback;
import trujillo.david.bluetoothle.models.ScanResult;
import trujillo.david.bluetoothle.utils.HexUtil;

public class Bluetooth {
    private static final String UUID_NOTIFY = "0000fff7-0000-1000-8000-00805f9b34fb";
    private static final String UUID_READ = "00002902-0000-1000-8000-00805f9b34fb";
    private static final String UUID_WRITE = "0000fff6-0000-1000-8000-00805f9b34fb";
    private static final String UUID_SERVICE = "0000fff0-0000-1000-8000-00805f9b34fb";
    public int delayConnection = 250;
    private BluetoothService bluetoothService;
    private ScanCallback scanResults;
    private ConnectCallback connectCallback;
    private Application application;
    private ReaderManager readerManager;
    private ServiceCallback serviceCallback = new ServiceCallback(){

        @Override
        public void onConnected() {
            Bluetooth.this.setConnectCallback(Bluetooth.this.connectCallback);
        }

        @Override
        public void onDisConnected() {
        }
    };
    private ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Bluetooth.this.bluetoothService = ((BluetoothService.BluetoothBinder)service).getService();
            Bluetooth.this.bluetoothService.setScanCallback(Bluetooth.this.callback);
            if (Bluetooth.this.serviceCallback != null) {
                Bluetooth.this.enableBluetooth();
                Bluetooth.this.serviceCallback.onConnected();
                Bluetooth.this.notifyData();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            Bluetooth.this.bluetoothService = null;
            if (Bluetooth.this.serviceCallback != null) {
                Bluetooth.this.serviceCallback.onDisConnected();
            }
        }
    };
    private BluetoothService.Callback callback = new BluetoothService.Callback(){

        @Override
        public void onStartScan() {
            if (Bluetooth.this.scanResults != null) {
                Bluetooth.this.scanResults.onStartScan();
            }
        }

        @Override
        public void onScanning(ScanResult scanResult) {
            if (Bluetooth.this.scanResults != null && scanResult.getDevice().getName() != null) {
                Bluetooth.this.scanResults.onScanning(scanResult);
            }
        }

        @Override
        public void onScanComplete() {
            if (Bluetooth.this.scanResults != null) {
                Bluetooth.this.scanResults.onScanComplete();
            }
        }

        @Override
        public void onConnecting() {
            if (Bluetooth.this.connectCallback != null) {
                Bluetooth.this.connectCallback.onConnecting();
            }
        }

        @Override
        public void onConnectFail() {
            if (Bluetooth.this.connectCallback != null) {
                Bluetooth.this.connectCallback.onConnectFail();
            }
        }

        @Override
        public void onDisConnected() {
            if (Bluetooth.this.connectCallback != null) {
                Bluetooth.this.connectCallback.onDisConnected();
            }
        }

        @Override
        public void onServicesDiscovered() {
            Bluetooth.this.notifyData();
            if (Bluetooth.this.connectCallback != null) {
                if (Bluetooth.this.delayConnection > 0) {
                    Handler handler = new Handler();
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Bluetooth.this.connectCallback.onConnected();
                        }
                    };
                    handler.postDelayed(runnable, (long)Bluetooth.this.delayConnection);
                } else {
                    Bluetooth.this.connectCallback.onConnected();
                }
            }
        }
    };

    public Bluetooth(Application application) {
        this.application = application;
        this.disconnect();
        if (this.bluetoothService == null) {
            this.bindService();
        }
    }

    public void setReaderManager(ReaderManager readerManager) {
        this.readerManager = readerManager;
    }

    public void setDelayConnection(int delayConnection) {
        this.delayConnection = delayConnection;
    }

    public void setBluetoothService(BluetoothService bluetoothService) {
        this.bluetoothService = bluetoothService;
    }

    public void scanDevices() {
        if (this.bluetoothService != null) {
            this.bluetoothService.scanDevice();
        }
    }

    public void stopScan() {
        try {
            this.bluetoothService.cancelScan();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setScanResults(ScanCallback scanResults) {
        this.scanResults = scanResults;
    }

    public void setConnectCallback(ConnectCallback connectCallback) {
        this.connectCallback = connectCallback;
    }

    public ConnectCallback getConnectCallback() {
        return this.connectCallback;
    }

    public void setTimeOut(long timeOut) {
        if (this.bluetoothService != null) {
            this.bluetoothService.setTimeOut(timeOut);
        }
    }

    public BluetoothService getBluetoothService() {
        return this.bluetoothService;
    }

    public void connect(ScanResult scanResult, Boolean cancel, Boolean autoConnect) {
        if (cancel.booleanValue()) {
            this.stopScan();
        }
        this.refreshDeviceCache();
        this.disconnect();
        this.bluetoothService.connectDevice(scanResult, autoConnect);
    }

    public void disconnect() {
        if (this.bluetoothService != null) {
            if (this.bluetoothService.getAdapter() != null) {
                this.bluetoothService.getAdapter().cancelDiscovery();
            }
            if (this.bluetoothService.getGatt() != null) {
                this.bluetoothService.getGatt().abortReliableWrite();
            }
            this.bluetoothService.closeConnect();
        }
    }

    public void scanAndConnectDFU(String name, Long timeout, BleGattCallback bleGattCallbackByName) {
        this.bluetoothService.scanAndConnectDeviceDFU(name, timeout, bleGattCallbackByName);
    }

    public void scanAndConnect(String name, ConnectCallback connectCallback) {
        this.bluetoothService.scanAndConnectDevice(name, false, connectCallback);
    }

    public void scanAndConnectMac(String mac, ConnectCallback connectCallback) {
        this.bluetoothService.scanAndConnectDeviceMac(mac, connectCallback);
    }

    public void writeData(byte[] value) {
        String hex = "";
        for (byte b : value) {
            hex = hex + HexUtil.decToHexTwo(b);
        }
        BleCharacterCallback bleCharacterCallback = new BleCharacterCallback(){

            @Override
            public void onSuccess(BluetoothGattCharacteristic characteristic) {
            }

            @Override
            public void onFailure(BleException exception) {
            }
        };
        if (!hex.isEmpty()) {
            this.bluetoothService.write(UUID_SERVICE, UUID_WRITE, hex, bleCharacterCallback);
        }
    }

    private void notifyData() {
        this.bluetoothService.notify(UUID_SERVICE, UUID_NOTIFY, new BleCharacterCallback(){

            @Override
            public void onFailure(BleException exception) {
            }

            @Override
            public void onSuccess(BluetoothGattCharacteristic characteristic) {
                if (Bluetooth.this.readerManager != null) {
                    Bluetooth.this.readerManager.processData(characteristic.getValue());
                }
            }
        });
    }

    public void readData() {
    }

    private void enableBluetooth() {
        this.bluetoothService.enableBluetooth();
    }

    private void bindService() {
        Intent bindIntent = new Intent((Context)this.application, BluetoothService.class);
        this.application.bindService(bindIntent, this.serviceConnection, 1);
    }

    private void unbindService() {
        try {
            this.application.unbindService(this.serviceConnection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshDeviceCache() {
        if (this.bluetoothService != null) {
            this.bluetoothService.refreshDeviceCache();
        }
    }

    public void destroy() {
        if (this.bluetoothService != null) {
            this.unbindService();
        }
    }
}

