/*
 * Decompiled with CFR 0.152.
 */
package wgz.datatom.com.utillibrary.view;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

public class PinchImageView
extends ImageView {
    public static final int SCALE_ANIMATOR_DURATION = 200;
    public static final float FLING_DAMPING_FACTOR = 0.9f;
    private static final float MAX_SCALE = 4.0f;
    public static final int PINCH_MODE_FREE = 0;
    public static final int PINCH_MODE_SCROLL = 1;
    public static final int PINCH_MODE_SCALE = 2;
    public static final int PINCH_MODE_NO_PINCH = 3;
    private View.OnClickListener mOnClickListener;
    private View.OnLongClickListener mOnLongClickListener;
    private Matrix mOuterMatrix = new Matrix();
    private int mPinchMode = 0;
    private PointF mLastMovePoint = new PointF();
    private PointF mScaleCenter = new PointF();
    private float mScaleBase = 0.0f;
    private ScaleAnimator mScaleAnimator;
    private FlingAnimator mFlingAnimator;
    private GestureDetector mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            PinchImageView.this.fling(velocityX, velocityY);
            return true;
        }

        public void onLongPress(MotionEvent e) {
            if (PinchImageView.this.mOnLongClickListener != null) {
                PinchImageView.this.mOnLongClickListener.onLongClick((View)PinchImageView.this);
            }
        }

        public boolean onDoubleTap(MotionEvent e) {
            PinchImageView.this.doubleTap(e.getX(), e.getY());
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (PinchImageView.this.mOnClickListener != null) {
                PinchImageView.this.mOnClickListener.onClick((View)PinchImageView.this);
            }
            return true;
        }
    });

    public PinchImageView(Context context) {
        super(context);
        this.initView();
    }

    public PinchImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public PinchImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    private void initView() {
        super.setScaleType(ImageView.ScaleType.MATRIX);
    }

    protected void onDraw(Canvas canvas) {
        if (this.getDrawable() != null) {
            this.setImageMatrix(this.getCurrentImageMatrix());
        }
        super.onDraw(canvas);
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.mOnClickListener = l;
    }

    public void setOnLongClickListener(View.OnLongClickListener l) {
        this.mOnLongClickListener = l;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
    }

    public Matrix getOuterMatrix() {
        return new Matrix(this.mOuterMatrix);
    }

    public Matrix getInnerMatrix() {
        Matrix result = new Matrix();
        if (this.getDrawable() != null) {
            float displayWidth = this.getMeasuredWidth();
            float displayHeight = this.getMeasuredHeight();
            if (displayWidth > 0.0f && displayHeight > 0.0f) {
                float imageWidth = this.getDrawable().getIntrinsicWidth();
                float imageHeight = this.getDrawable().getIntrinsicHeight();
                if (imageWidth > 0.0f && imageHeight > 0.0f) {
                    float scale = imageWidth / imageHeight > displayWidth / displayHeight ? displayWidth / imageWidth : displayHeight / imageHeight;
                    result.postScale(scale, scale, imageWidth / 2.0f, imageHeight / 2.0f);
                    result.postTranslate((displayWidth - imageWidth) / 2.0f, (displayHeight - imageHeight) / 2.0f);
                }
            }
        }
        return result;
    }

    public Matrix getCurrentImageMatrix() {
        Matrix result = this.getInnerMatrix();
        result.postConcat(this.mOuterMatrix);
        return result;
    }

    public RectF getImageBound() {
        if (this.getDrawable() == null) {
            return null;
        }
        Matrix matrix = this.getCurrentImageMatrix();
        RectF bound = new RectF(0.0f, 0.0f, (float)this.getDrawable().getIntrinsicWidth(), (float)this.getDrawable().getIntrinsicHeight());
        matrix.mapRect(bound);
        return bound;
    }

    public int getPinchMode() {
        return this.mPinchMode;
    }

    public void startNoPinch() {
        this.mPinchMode = 3;
        this.mLastMovePoint = new PointF();
        this.mScaleCenter = new PointF();
        this.mScaleBase = 0.0f;
    }

    public boolean animFromTo(Matrix matrixFrom, Matrix matrixTo) {
        if (this.getDrawable() == null) {
            return false;
        }
        if (this.mScaleAnimator != null) {
            this.mScaleAnimator.cancel();
            this.mScaleAnimator = null;
        }
        if (this.mFlingAnimator != null) {
            this.mFlingAnimator.cancel();
            this.mFlingAnimator = null;
        }
        this.mScaleAnimator = new ScaleAnimator(matrixFrom, matrixTo);
        this.mScaleAnimator.start();
        return true;
    }

    public void endNoPinch() {
        this.mPinchMode = 0;
    }

    public void reset() {
        this.mOuterMatrix = new Matrix();
        this.onOuterMatrixChanged();
        this.mPinchMode = 0;
        this.mLastMovePoint = new PointF();
        this.mScaleCenter = new PointF();
        this.mScaleBase = 0.0f;
        if (this.mScaleAnimator != null) {
            this.mScaleAnimator.cancel();
            this.mScaleAnimator = null;
        }
        if (this.mFlingAnimator != null) {
            this.mFlingAnimator.cancel();
            this.mFlingAnimator = null;
        }
        this.invalidate();
    }

    protected float getMaxScale() {
        return 4.0f;
    }

    protected float calculateNextScale(float innerScale, float outerScale) {
        float currentScale = innerScale * outerScale;
        if (currentScale < 4.0f) {
            return 4.0f;
        }
        return innerScale;
    }

    protected void onOuterMatrixChanged() {
    }

    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        if (this.mPinchMode == 3) {
            return true;
        }
        this.mGestureDetector.onTouchEvent(event);
        int action = event.getAction() & 0xFF;
        if (action == 1 || action == 3) {
            if (this.mPinchMode == 2) {
                this.scaleEnd();
            }
            this.mPinchMode = 0;
        } else if (action == 6) {
            if (this.mPinchMode == 2 && event.getPointerCount() > 2) {
                if (event.getAction() >> 8 == 0) {
                    this.saveScaleContext(event.getX(1), event.getY(1), event.getX(2), event.getY(2));
                } else if (event.getAction() >> 8 == 1) {
                    this.saveScaleContext(event.getX(0), event.getY(0), event.getX(2), event.getY(2));
                }
            }
        } else if (action == 0) {
            if (this.mScaleAnimator == null || !this.mScaleAnimator.isRunning()) {
                if (this.mFlingAnimator != null) {
                    this.mFlingAnimator.cancel();
                    this.mFlingAnimator = null;
                }
                this.mPinchMode = 1;
                this.mLastMovePoint.set(event.getX(), event.getY());
            }
        } else if (action == 5) {
            if (this.mFlingAnimator != null) {
                this.mFlingAnimator.cancel();
                this.mFlingAnimator = null;
            }
            if (this.mScaleAnimator != null) {
                this.mScaleAnimator.cancel();
                this.mScaleAnimator = null;
            }
            this.mPinchMode = 2;
            this.saveScaleContext(event.getX(0), event.getY(0), event.getX(1), event.getY(1));
        } else if (!(action != 2 || this.mScaleAnimator != null && this.mScaleAnimator.isRunning())) {
            if (this.mPinchMode == 1) {
                this.scrollBy(event.getX() - this.mLastMovePoint.x, event.getY() - this.mLastMovePoint.y);
                this.mLastMovePoint.set(event.getX(), event.getY());
            } else if (this.mPinchMode == 2 && event.getPointerCount() > 1) {
                float distance = MathUtils.getDistance(event.getX(0), event.getY(0), event.getX(1), event.getY(1));
                float[] lineCenter = MathUtils.getCenterPoint(event.getX(0), event.getY(0), event.getX(1), event.getY(1));
                this.mLastMovePoint.set(lineCenter[0], lineCenter[1]);
                this.scale(this.mScaleCenter, this.mScaleBase, distance, this.mLastMovePoint);
            }
        }
        return true;
    }

    private boolean scrollBy(float xDiff, float yDiff) {
        if (this.getDrawable() == null) {
            return false;
        }
        RectF bound = this.getImageBound();
        float displayWidth = this.getMeasuredWidth();
        float displayHeight = this.getMeasuredHeight();
        if (bound.right - bound.left < displayWidth) {
            xDiff = 0.0f;
        } else if (bound.left + xDiff > 0.0f) {
            xDiff = bound.left < 0.0f ? -bound.left : 0.0f;
        } else if (bound.right + xDiff < displayWidth) {
            xDiff = bound.right > displayWidth ? displayWidth - bound.right : 0.0f;
        }
        if (bound.bottom - bound.top < displayHeight) {
            yDiff = 0.0f;
        } else if (bound.top + yDiff > 0.0f) {
            yDiff = bound.top < 0.0f ? -bound.top : 0.0f;
        } else if (bound.bottom + yDiff < displayHeight) {
            yDiff = bound.bottom > displayHeight ? displayHeight - bound.bottom : 0.0f;
        }
        this.mOuterMatrix.postTranslate(xDiff, yDiff);
        this.onOuterMatrixChanged();
        this.invalidate();
        return xDiff != 0.0f || yDiff != 0.0f;
    }

    private void saveScaleContext(float x1, float y1, float x2, float y2) {
        this.mScaleBase = MathUtils.getMatrixScale(this.mOuterMatrix)[0] / MathUtils.getDistance(x1, y1, x2, y2);
        float[] center = MathUtils.inverseMatrixPoint(MathUtils.getCenterPoint(x1, y1, x2, y2), this.mOuterMatrix);
        this.mScaleCenter.set(center[0], center[1]);
    }

    private void scale(PointF scaleCenter, float scaleBase, float distance, PointF lineCenter) {
        if (this.getDrawable() == null) {
            return;
        }
        float scale = scaleBase * distance;
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale, scaleCenter.x, scaleCenter.y);
        matrix.postTranslate(lineCenter.x - scaleCenter.x, lineCenter.y - scaleCenter.y);
        this.mOuterMatrix = matrix;
        this.onOuterMatrixChanged();
        this.invalidate();
    }

    private void doubleTap(float x, float y) {
        if (this.mScaleAnimator != null && this.mScaleAnimator.isRunning() || this.getDrawable() == null) {
            return;
        }
        Matrix innerMatrix = this.getInnerMatrix();
        float innerScale = MathUtils.getMatrixScale(innerMatrix)[0];
        float outerScale = MathUtils.getMatrixScale(this.mOuterMatrix)[0];
        float currentScale = innerScale * outerScale;
        float displayWidth = this.getMeasuredWidth();
        float displayHeight = this.getMeasuredHeight();
        float maxScale = this.getMaxScale();
        float nextScale = this.calculateNextScale(innerScale, outerScale);
        if (nextScale < innerScale) {
            nextScale = innerScale;
        } else if (nextScale > maxScale) {
            nextScale = maxScale;
        }
        Matrix animStart = new Matrix(this.mOuterMatrix);
        Matrix animEnd = new Matrix(this.mOuterMatrix);
        animEnd.postScale(nextScale / currentScale, nextScale / currentScale, x, y);
        animEnd.postTranslate(displayWidth / 2.0f - x, displayHeight / 2.0f - y);
        Matrix testMatrix = new Matrix(innerMatrix);
        testMatrix.postConcat(animEnd);
        RectF testBound = new RectF(0.0f, 0.0f, (float)this.getDrawable().getIntrinsicWidth(), (float)this.getDrawable().getIntrinsicHeight());
        testMatrix.mapRect(testBound);
        float postX = 0.0f;
        float postY = 0.0f;
        if (testBound.right - testBound.left < displayWidth) {
            postX = displayWidth / 2.0f - (testBound.right + testBound.left) / 2.0f;
        } else if (testBound.left > 0.0f) {
            postX = -testBound.left;
        } else if (testBound.right < displayWidth) {
            postX = displayWidth - testBound.right;
        }
        if (testBound.bottom - testBound.top < displayHeight) {
            postY = displayHeight / 2.0f - (testBound.bottom + testBound.top) / 2.0f;
        } else if (testBound.top > 0.0f) {
            postY = -testBound.top;
        } else if (testBound.bottom < displayHeight) {
            postY = displayHeight - testBound.bottom;
        }
        animEnd.postTranslate(postX, postY);
        if (this.mFlingAnimator != null) {
            this.mFlingAnimator.cancel();
            this.mFlingAnimator = null;
        }
        this.mScaleAnimator = new ScaleAnimator(animStart, animEnd);
        this.mScaleAnimator.start();
    }

    private void scaleEnd() {
        if (this.mScaleAnimator != null && this.mScaleAnimator.isRunning() || this.getDrawable() == null) {
            return;
        }
        boolean change = false;
        Matrix currentMatrix = this.getCurrentImageMatrix();
        float currentScale = MathUtils.getMatrixScale(currentMatrix)[0];
        float outerScale = MathUtils.getMatrixScale(this.mOuterMatrix)[0];
        float displayWidth = this.getMeasuredWidth();
        float displayHeight = this.getMeasuredHeight();
        float maxScale = this.getMaxScale();
        float scalePost = 1.0f;
        float postX = 0.0f;
        float postY = 0.0f;
        if (currentScale > maxScale) {
            scalePost = maxScale / currentScale;
        }
        if (outerScale * scalePost < 1.0f) {
            scalePost = 1.0f / outerScale;
        }
        if (scalePost != 1.0f) {
            change = true;
        }
        Matrix testMatrix = new Matrix(currentMatrix);
        testMatrix.postScale(scalePost, scalePost, this.mLastMovePoint.x, this.mLastMovePoint.y);
        RectF testBound = new RectF(0.0f, 0.0f, (float)this.getDrawable().getIntrinsicWidth(), (float)this.getDrawable().getIntrinsicHeight());
        testMatrix.mapRect(testBound);
        if (testBound.right - testBound.left < displayWidth) {
            postX = displayWidth / 2.0f - (testBound.right + testBound.left) / 2.0f;
        } else if (testBound.left > 0.0f) {
            postX = -testBound.left;
        } else if (testBound.right < displayWidth) {
            postX = displayWidth - testBound.right;
        }
        if (testBound.bottom - testBound.top < displayHeight) {
            postY = displayHeight / 2.0f - (testBound.bottom + testBound.top) / 2.0f;
        } else if (testBound.top > 0.0f) {
            postY = -testBound.top;
        } else if (testBound.bottom < displayHeight) {
            postY = displayHeight - testBound.bottom;
        }
        if (postX != 0.0f || postY != 0.0f) {
            change = true;
        }
        if (change) {
            if (this.mFlingAnimator != null) {
                this.mFlingAnimator.cancel();
                this.mFlingAnimator = null;
            }
            Matrix animStart = new Matrix(this.mOuterMatrix);
            Matrix animEnd = new Matrix(this.mOuterMatrix);
            animEnd.postScale(scalePost, scalePost, this.mLastMovePoint.x, this.mLastMovePoint.y);
            animEnd.postTranslate(postX, postY);
            this.mScaleAnimator = new ScaleAnimator(animStart, animEnd);
            this.mScaleAnimator.start();
        }
    }

    private void fling(float vx, float vy) {
        if (!(this.mScaleAnimator != null && this.mScaleAnimator.isRunning() || this.getDrawable() == null)) {
            if (this.mFlingAnimator != null) {
                this.mFlingAnimator.cancel();
                this.mFlingAnimator = null;
            }
            this.mFlingAnimator = new FlingAnimator(new float[]{vx / 1000.0f * 16.0f, vy / 1000.0f * 16.0f});
            this.mFlingAnimator.start();
        }
    }

    private static class MathUtils {
        private MathUtils() {
        }

        public static float getDistance(float x1, float y1, float x2, float y2) {
            float x = x1 - x2;
            float y = y1 - y2;
            return (float)Math.sqrt(x * x + y * y);
        }

        public static float[] getCenterPoint(float x1, float y1, float x2, float y2) {
            return new float[]{(x1 + x2) / 2.0f, (y1 + y2) / 2.0f};
        }

        public static float[] getMatrixScale(Matrix matrix) {
            if (matrix != null) {
                float[] value = new float[9];
                matrix.getValues(value);
                return new float[]{value[0], value[4]};
            }
            return new float[2];
        }

        public static float[] inverseMatrixPoint(float[] point, Matrix matrix) {
            if (point != null && matrix != null) {
                float[] dst = new float[2];
                Matrix inverse = new Matrix();
                matrix.invert(inverse);
                inverse.mapPoints(dst, point);
                return dst;
            }
            return new float[2];
        }
    }

    private class ScaleAnimator
    extends ValueAnimator
    implements ValueAnimator.AnimatorUpdateListener {
        private float[] mStart = new float[9];
        private float[] mEnd = new float[9];

        public ScaleAnimator(Matrix start, Matrix end) {
            this.setFloatValues(new float[]{0.0f, 1.0f});
            this.setDuration(200L);
            this.addUpdateListener(this);
            start.getValues(this.mStart);
            end.getValues(this.mEnd);
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            float[] result = new float[9];
            for (int i = 0; i < 9; ++i) {
                result[i] = this.mStart[i] + (this.mEnd[i] - this.mStart[i]) * value;
            }
            PinchImageView.this.mOuterMatrix.setValues(result);
            PinchImageView.this.onOuterMatrixChanged();
            PinchImageView.this.invalidate();
        }
    }

    private class FlingAnimator
    extends ValueAnimator
    implements ValueAnimator.AnimatorUpdateListener {
        private float[] mVector;

        public FlingAnimator(float[] vector) {
            this.setFloatValues(new float[]{0.0f, 1.0f});
            this.setDuration(1000000L);
            this.addUpdateListener(this);
            this.mVector = vector;
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            boolean result = PinchImageView.this.scrollBy(this.mVector[0], this.mVector[1]);
            this.mVector[0] = this.mVector[0] * 0.9f;
            this.mVector[1] = this.mVector[1] * 0.9f;
            if (!result || MathUtils.getDistance(0.0f, 0.0f, this.mVector[0], this.mVector[1]) < 1.0f) {
                animation.cancel();
            }
        }
    }
}

