/*
 * Decompiled with CFR 0.152.
 */
package wgz.datatom.com.utillibrary.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private StringUtil() {
        throw new AssertionError();
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static int length(CharSequence str) {
        return str == null ? 0 : str.length();
    }

    public static String nullStrToEmpty(Object str) {
        return str == null ? "" : (str instanceof String ? (String)str : str.toString());
    }

    public static String capitalizeFirstLetter(String str) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        char c = str.charAt(0);
        return !Character.isLetter(c) || Character.isUpperCase(c) ? str : new StringBuilder(str.length()).append(Character.toUpperCase(c)).append(str.substring(1)).toString();
    }

    public static String utf8Encode(String str) {
        if (!StringUtil.isEmpty(str) && str.getBytes().length != str.length()) {
            try {
                return URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UnsupportedEncodingException occurred. ", e);
            }
        }
        return str;
    }

    public static String getHrefInnerHtml(String href) {
        if (StringUtil.isEmpty(href)) {
            return "";
        }
        String hrefReg = ".*<[\\s]*a[\\s]*.*>(.+?)<[\\s]*/a[\\s]*>.*";
        Pattern hrefPattern = Pattern.compile(hrefReg, 2);
        Matcher hrefMatcher = hrefPattern.matcher(href);
        if (hrefMatcher.matches()) {
            return hrefMatcher.group(1);
        }
        return href;
    }

    public static String htmlEscapeCharsToString(String source) {
        return StringUtil.isEmpty(source) ? source : source.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&").replaceAll("&quot;", "\"");
    }

    public static String fullWidthToHalfWidth(String s) {
        if (StringUtil.isEmpty(s)) {
            return s;
        }
        char[] source = s.toCharArray();
        for (int i = 0; i < source.length; ++i) {
            source[i] = source[i] == '\u3000' ? 32 : (source[i] >= '\uff01' && source[i] <= '\uff5e' ? (char)(source[i] - 65248) : source[i]);
        }
        return new String(source);
    }

    public static String halfWidthToFullWidth(String s) {
        if (StringUtil.isEmpty(s)) {
            return s;
        }
        char[] source = s.toCharArray();
        for (int i = 0; i < source.length; ++i) {
            source[i] = source[i] == ' ' ? 12288 : (source[i] >= '!' && source[i] <= '~' ? (char)(source[i] + 65248) : source[i]);
        }
        return new String(source);
    }

    public static String replaceBlanktihuan(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static boolean isEmpty(String string) {
        return string == null || "".equals(string.trim());
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtil.isEmpty(string);
    }

    public static boolean isEmpty(String ... strings) {
        boolean result = true;
        for (String string : strings) {
            if (!StringUtil.isNotEmpty(string)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isNotEmpty(String ... strings) {
        boolean result = true;
        for (String string : strings) {
            if (!StringUtil.isEmpty(string)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static String filterEmpty(String string) {
        return StringUtil.isNotEmpty(string) ? string : "";
    }

    public static String replace(String string, char oldchar, char newchar) {
        char[] chars = string.toCharArray();
        for (int w = 0; w < chars.length; ++w) {
            if (chars[w] != oldchar) continue;
            chars[w] = newchar;
            break;
        }
        return new String(chars);
    }

    public static String[] split(String string, char ch) {
        ArrayList<String> stringList = new ArrayList<String>();
        char[] chars = string.toCharArray();
        int nextStart = 0;
        for (int w = 0; w < chars.length; ++w) {
            if (ch != chars[w]) continue;
            stringList.add(new String(chars, nextStart, w - nextStart));
            nextStart = w + 1;
            if (nextStart != chars.length) continue;
            stringList.add("");
        }
        if (nextStart < chars.length) {
            stringList.add(new String(chars, nextStart, chars.length - 1 - nextStart + 1));
        }
        return stringList.toArray(new String[stringList.size()]);
    }

    public static int countLength(String string) {
        int length = 0;
        char[] chars = string.toCharArray();
        for (int w = 0; w < string.length(); ++w) {
            char ch = chars[w];
            if (ch >= '\u0391' && ch <= '\uffe5') {
                ++length;
                ++length;
                continue;
            }
            ++length;
        }
        return length;
    }

    private static char[] getChars(char[] chars, int startIndex) {
        int endIndex;
        if (Character.isDigit(chars[startIndex])) {
            for (endIndex = startIndex + 1; endIndex < chars.length && Character.isDigit(chars[endIndex]); ++endIndex) {
            }
        }
        char[] resultChars = new char[endIndex - startIndex];
        System.arraycopy(chars, startIndex, resultChars, 0, resultChars.length);
        return resultChars;
    }

    public static boolean isAllDigital(char[] chars) {
        boolean result = true;
        for (int w = 0; w < chars.length; ++w) {
            if (Character.isDigit(chars[w])) continue;
            result = false;
            break;
        }
        return result;
    }

    public static String removeChar(String string, char ch) {
        StringBuffer sb = new StringBuffer();
        for (char cha : string.toCharArray()) {
            if (cha == '-') continue;
            sb.append(cha);
        }
        return sb.toString();
    }

    public static String removeChar(String string, int index) {
        String result = null;
        char[] chars = string.toCharArray();
        result = index == 0 ? new String(chars, 1, chars.length - 1) : (index == chars.length - 1 ? new String(chars, 0, chars.length - 1) : new String(chars, 0, index) + new String(chars, index + 1, chars.length - index));
        return result;
    }

    public static String removeChar(String string, int index, char ch) {
        String result = null;
        char[] chars = string.toCharArray();
        result = chars.length > 0 && chars[index] == ch ? (index == 0 ? new String(chars, 1, chars.length - 1) : (index == chars.length - 1 ? new String(chars, 0, chars.length - 1) : new String(chars, 0, index) + new String(chars, index + 1, chars.length - index))) : string;
        return result;
    }

    public static String filterBlank(String string) {
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    public static String toLowerCase(String str, int beginIndex, int endIndex) {
        return str.replaceFirst(str.substring(beginIndex, endIndex), str.substring(beginIndex, endIndex).toLowerCase(Locale.getDefault()));
    }

    public static String toUpperCase(String str, int beginIndex, int endIndex) {
        return str.replaceFirst(str.substring(beginIndex, endIndex), str.substring(beginIndex, endIndex).toUpperCase(Locale.getDefault()));
    }

    public static String firstLetterToLowerCase(String str) {
        return StringUtil.toLowerCase(str, 0, 1);
    }

    public static String firstLetterToUpperCase(String str) {
        return StringUtil.toUpperCase(str, 0, 1);
    }

    public static String MD5(String string) {
        String result = null;
        try {
            char[] charArray = string.toCharArray();
            byte[] byteArray = new byte[charArray.length];
            for (int i = 0; i < charArray.length; ++i) {
                byteArray[i] = (byte)charArray[i];
            }
            StringBuffer hexValue = new StringBuffer();
            byte[] md5Bytes = MessageDigest.getInstance("MD5").digest(byteArray);
            for (int i = 0; i < md5Bytes.length; ++i) {
                int val = md5Bytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
            }
            result = hexValue.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean startsWithIgnoreCase(String sourceString, String newString) {
        int sourceLength;
        int newLength = newString.length();
        if (newLength == (sourceLength = sourceString.length())) {
            return newString.equalsIgnoreCase(sourceString);
        }
        if (newLength < sourceLength) {
            char[] newChars = new char[newLength];
            sourceString.getChars(0, newLength, newChars, 0);
            return newString.equalsIgnoreCase(String.valueOf(newChars));
        }
        return false;
    }

    public static boolean endsWithIgnoreCase(String sourceString, String newString) {
        int sourceLength;
        int newLength = newString.length();
        if (newLength == (sourceLength = sourceString.length())) {
            return newString.equalsIgnoreCase(sourceString);
        }
        if (newLength < sourceLength) {
            char[] newChars = new char[newLength];
            sourceString.getChars(sourceLength - newLength, sourceLength, newChars, 0);
            return newString.equalsIgnoreCase(String.valueOf(newChars));
        }
        return false;
    }

    public static String checkLength(String string, int maxLength, String appendString) {
        if (string.length() > maxLength) {
            string = string.substring(0, maxLength);
            if (appendString != null) {
                string = string + appendString;
            }
        }
        return string;
    }

    public static String checkLength(String string, int maxLength) {
        return StringUtil.checkLength(string, maxLength, "\u2026");
    }
}

