/*
 * Decompiled with CFR 0.152.
 */
package wgz.datatom.com.utillibrary.util;

import android.os.Environment;
import android.os.StatFs;
import java.io.File;

public class SDCardUtil {
    private SDCardUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static boolean isSDCardEnable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getSDCardPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator;
    }

    public static long getSDCardAllSize() {
        if (SDCardUtil.isSDCardEnable()) {
            StatFs stat = new StatFs(SDCardUtil.getSDCardPath());
            long availableBlocks = (long)stat.getAvailableBlocks() - 4L;
            long freeBlocks = stat.getAvailableBlocks();
            return freeBlocks * availableBlocks;
        }
        return 0L;
    }

    public static long getFreeBytes(String filePath) {
        filePath = filePath.startsWith(SDCardUtil.getSDCardPath()) ? SDCardUtil.getSDCardPath() : Environment.getDataDirectory().getAbsolutePath();
        StatFs stat = new StatFs(filePath);
        long availableBlocks = (long)stat.getAvailableBlocks() - 4L;
        return (long)stat.getBlockSize() * availableBlocks;
    }

    public static String getRootDirectoryPath() {
        return Environment.getRootDirectory().getAbsolutePath();
    }
}

