/*
 * Decompiled with CFR 0.152.
 */
package com.damiao.pikachu.util;

import java.io.Closeable;
import java.math.BigDecimal;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u001a%\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\u0010\t\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\b\u0010\u000e\u001a\u00020\u000bH\u0000\u001a\f\u0010\u000f\u001a\u00020\u000b*\u00020\u000bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"GB", "", "KB", "MB", "closeAll", "", "close", "", "Ljava/io/Closeable;", "([Ljava/io/Closeable;)V", "getDownloadFileSizeDescription", "", "contentLength", "", "uuid", "sha1", "pikachu_release"})
public final class PKCommonKt {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;

    @NotNull
    public static final String uuid() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        return string;
    }

    @NotNull
    public static final String sha1(@NotNull String $this$sha1) {
        Intrinsics.checkParameterIsNotNull((Object)$this$sha1, (String)"$this$sha1");
        return ByteString.Companion.encodeUtf8($this$sha1).sha1().hex();
    }

    @NotNull
    public static final String getDownloadFileSizeDescription(long contentLength) {
        String string;
        if (contentLength <= (long)1024) {
            string = "" + contentLength + 'B';
        } else if (contentLength <= (long)0x100000) {
            string = contentLength / (long)1024 + "KB";
        } else if (contentLength <= (long)0x40000000) {
            string = contentLength / (long)0x100000 + "MB";
        } else if (contentLength >= (long)0x40000000) {
            double d = (double)contentLength / (double)0x40000000;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
            string = stringBuilder.append(bigDecimal.setScale(2, 1)).append("GB").toString();
        } else {
            string = "unknown";
        }
        return string;
    }

    public static final void closeAll(Closeable ... close) {
        Intrinsics.checkParameterIsNotNull((Object)close, (String)"close");
        Closeable[] closeableArray = close;
        int n = closeableArray.length;
        for (int i = 0; i < n; ++i) {
            Closeable closeable;
            Closeable closeable2 = closeable = closeableArray[i];
            if (closeable2 == null) continue;
            Util.closeQuietly((Closeable)closeable2);
        }
    }
}

