/*
 * Decompiled with CFR 0.152.
 */
package com.damiao.pikachu.core.engine;

import android.os.Handler;
import android.os.Looper;
import com.damiao.pikachu.Pikachu;
import com.damiao.pikachu.common.PKDownloadTask;
import com.damiao.pikachu.common.PKLog;
import com.damiao.pikachu.common.PKTaskProcessListener;
import com.damiao.pikachu.core.engine.PKDownloadEngine;
import com.damiao.pikachu.core.engine.PKMagnetDownloadEngine;
import com.damiao.pikachu.core.engine.PKMagnetDownloadEngine$WhenMappings;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.libtorrent4j.AddTorrentParams;
import org.libtorrent4j.AlertListener;
import org.libtorrent4j.SessionManager;
import org.libtorrent4j.TorrentFlags;
import org.libtorrent4j.TorrentStatus;
import org.libtorrent4j.alerts.AddTorrentAlert;
import org.libtorrent4j.alerts.Alert;
import org.libtorrent4j.alerts.AlertType;
import org.libtorrent4j.alerts.BlockFinishedAlert;
import org.libtorrent4j.alerts.FileCompletedAlert;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/damiao/pikachu/core/engine/PKMagnetDownloadEngine;", "Lcom/damiao/pikachu/core/engine/PKDownloadEngine;", "client", "Lcom/damiao/pikachu/Pikachu;", "(Lcom/damiao/pikachu/Pikachu;)V", "mainHandler", "Landroid/os/Handler;", "checkProto", "", "downloadTask", "Lcom/damiao/pikachu/common/PKDownloadTask;", "download", "", "needDbProgress", "supportProto", "", "", "Companion", "pikachu_release"})
public final class PKMagnetDownloadEngine
implements PKDownloadEngine {
    private final Handler mainHandler;
    private final Pikachu client;
    @NotNull
    public static final String MAGNET_PROTO = "magnet:?xt=urn:btih:";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<String> supportProto() {
        return CollectionsKt.listOf((Object)MAGNET_PROTO);
    }

    @Override
    public boolean needDbProgress() {
        return true;
    }

    @Override
    public void download(@NotNull PKDownloadTask downloadTask) {
        Intrinsics.checkParameterIsNotNull((Object)downloadTask, (String)"downloadTask");
        if (!this.checkProto(downloadTask)) {
            return;
        }
        File localFile = new File(downloadTask.getPkRequest().getLocalSinkFilePath());
        SessionManager sessionManager = new SessionManager();
        downloadTask.getTaskStatusChangedListener$pikachu_release().add(new Function1<Integer, Unit>(this, sessionManager, downloadTask, localFile){
            final /* synthetic */ PKMagnetDownloadEngine this$0;
            final /* synthetic */ SessionManager $sessionManager;
            final /* synthetic */ PKDownloadTask $downloadTask;
            final /* synthetic */ File $localFile;

            public final void invoke(int status) {
                switch (status) {
                    case 0: {
                        this.$sessionManager.pause();
                        PKLog.INSTANCE.debug("\u78c1\u529b\u94fe\u63a5\u4e0b\u8f7d " + this.$downloadTask.getDownloadFileName() + " \u88ab\u6682\u505c");
                        break;
                    }
                    case 1: {
                        this.$sessionManager.resume();
                        PKLog.INSTANCE.debug("\u78c1\u529b\u94fe\u63a5\u4e0b\u8f7d " + this.$downloadTask.getDownloadFileName() + " \u88ab\u6062\u590d");
                        break;
                    }
                    case 2: {
                        this.$localFile.delete();
                        this.$sessionManager.stop();
                        PKMagnetDownloadEngine.access$getMainHandler$p(this.this$0).post(new Runnable(this){
                            final /* synthetic */ download.1 this$0;

                            public final void run() {
                                PKLog.INSTANCE.debug("\u78c1\u529b\u94fe\u63a5\u4e0b\u8f7d " + this.this$0.$downloadTask.getDownloadFileName() + " \u88ab\u53d6\u6d88\uff0c" + "\u505c\u6b62\u8be5\u4efb\u52a1\u7684\u4e0b\u8f7d");
                                PKTaskProcessListener pKTaskProcessListener = this.this$0.$downloadTask.getPkRequest().getTaskProcessListener();
                                if (pKTaskProcessListener != null) {
                                    pKTaskProcessListener.onCancel(this.this$0.$downloadTask);
                                }
                                Iterable $this$forEach$iv = PKMagnetDownloadEngine.access$getClient$p(this.this$0.this$0).getPkGlobalTaskProcessListenerList();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    PKTaskProcessListener it = (PKTaskProcessListener)element$iv;
                                    boolean bl = false;
                                    it.onCancel(this.this$0.$downloadTask);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        PKMagnetDownloadEngine.access$getClient$p(this.this$0).getPkDispatcher().complete(this.$downloadTask);
                        break;
                    }
                }
            }
            {
                this.this$0 = pKMagnetDownloadEngine;
                this.$sessionManager = sessionManager;
                this.$downloadTask = pKDownloadTask;
                this.$localFile = file;
                super(1);
            }
        });
        sessionManager.addListener(new AlertListener(this, downloadTask){
            final /* synthetic */ PKMagnetDownloadEngine this$0;
            final /* synthetic */ PKDownloadTask $downloadTask;

            public void alert(@NotNull Alert<?> alert2) {
                Intrinsics.checkParameterIsNotNull(alert2, (String)"alert");
                AlertType alertType = alert2.type();
                if (alertType != null) {
                    switch (PKMagnetDownloadEngine$WhenMappings.$EnumSwitchMapping$0[alertType.ordinal()]) {
                        case 1: {
                            AddTorrentAlert ata = (AddTorrentAlert)alert2;
                            PKLog.INSTANCE.debug("\u78c1\u529b\u79cd\u5b50\u6dfb\u52a0\u6210\u529f " + ata.torrentName() + ", \u5f00\u59cb\u4e0b\u8f7d\u76ee\u6807\u6587\u4ef6");
                            this.$downloadTask.start$pikachu_release();
                            PKMagnetDownloadEngine.access$getMainHandler$p(this.this$0).post(new Runnable(this){
                                final /* synthetic */ download.2 this$0;

                                public final void run() {
                                    PKTaskProcessListener pKTaskProcessListener = this.this$0.$downloadTask.getPkRequest().getTaskProcessListener();
                                    if (pKTaskProcessListener != null) {
                                        pKTaskProcessListener.onStart(this.this$0.$downloadTask);
                                    }
                                    Iterable $this$forEach$iv = PKMagnetDownloadEngine.access$getClient$p(this.this$0.this$0).getPkGlobalTaskProcessListenerList();
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        PKTaskProcessListener it = (PKTaskProcessListener)element$iv;
                                        boolean bl = false;
                                        it.onStart(this.this$0.$downloadTask);
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                            break;
                        }
                        case 2: {
                            BlockFinishedAlert bfa = (BlockFinishedAlert)alert2;
                            TorrentStatus status = bfa.handle().status();
                            long total = status.total();
                            long progress = status.totalDone();
                            PKLog.INSTANCE.debug("\u78c1\u529b\u5206\u5757\u4e0b\u8f7d\u5b8c\u6210 " + bfa.torrentName() + ' ' + "\u5df2\u4e0b\u8f7d " + progress + " \u603b\u5927\u5c0f " + total + " \u4e0b\u8f7d\u767e\u5206\u6bd4 " + (int)(status.progress() * (float)100));
                            boolean firstChange = false;
                            if (total != 0L && this.$downloadTask.getContentLength() == 0L) {
                                this.$downloadTask.setContentLength(status.total());
                                this.$downloadTask.setDownloadFileName(bfa.torrentName());
                                PKDownloadTask.triggerPersist$pikachu_release$default(this.$downloadTask, false, 1, null);
                                firstChange = true;
                            }
                            if (this.$downloadTask.getProgress() == progress && !firstChange) {
                                return;
                            }
                            this.$downloadTask.setProgress(progress);
                            PKMagnetDownloadEngine.access$getClient$p(this.this$0).getPkDownloadTaskPersister().updateDownloadTask(this.$downloadTask);
                            PKMagnetDownloadEngine.access$getMainHandler$p(this.this$0).post(new Runnable(this, progress, total){
                                final /* synthetic */ download.2 this$0;
                                final /* synthetic */ long $progress;
                                final /* synthetic */ long $total;

                                public final void run() {
                                    PKTaskProcessListener pKTaskProcessListener = this.this$0.$downloadTask.getPkRequest().getTaskProcessListener();
                                    if (pKTaskProcessListener != null) {
                                        pKTaskProcessListener.onProcess(this.$progress, this.$total, this.this$0.$downloadTask);
                                    }
                                    Iterable $this$forEach$iv = PKMagnetDownloadEngine.access$getClient$p(this.this$0.this$0).getPkGlobalTaskProcessListenerList();
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        PKTaskProcessListener it = (PKTaskProcessListener)element$iv;
                                        boolean bl = false;
                                        it.onProcess(this.$progress, this.$total, this.this$0.$downloadTask);
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$progress = l;
                                    this.$total = l2;
                                }
                            });
                            break;
                        }
                        case 3: {
                            FileCompletedAlert fca = (FileCompletedAlert)alert2;
                            PKLog.INSTANCE.debug("\u78c1\u529b\u94fe\u63a5\u76ee\u6807\u6587\u4ef6 " + fca.torrentName() + " \u5df2\u7ecf\u4e0b\u8f7d\u5b8c\u6210");
                            this.$downloadTask.success$pikachu_release();
                            this.$downloadTask.setDownloadResultFile(new File(this.$downloadTask.getPkRequest().getLocalSinkFilePath(), fca.torrentName()));
                            PKMagnetDownloadEngine.access$getMainHandler$p(this.this$0).post(new Runnable(this){
                                final /* synthetic */ download.2 this$0;

                                public final void run() {
                                    PKTaskProcessListener pKTaskProcessListener = this.this$0.$downloadTask.getPkRequest().getTaskProcessListener();
                                    if (pKTaskProcessListener != null) {
                                        pKTaskProcessListener.onComplete(this.this$0.$downloadTask);
                                    }
                                    Iterable $this$forEach$iv = PKMagnetDownloadEngine.access$getClient$p(this.this$0.this$0).getPkGlobalTaskProcessListenerList();
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        PKTaskProcessListener it = (PKTaskProcessListener)element$iv;
                                        boolean bl = false;
                                        it.onComplete(this.this$0.$downloadTask);
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                            PKMagnetDownloadEngine.access$getClient$p(this.this$0).getPkDispatcher().complete(this.$downloadTask);
                            break;
                        }
                    }
                }
            }

            @Nullable
            public int[] types() {
                return null;
            }
            {
                this.this$0 = $outer;
                this.$downloadTask = $captured_local_variable$1;
            }
        });
        sessionManager.start();
        sessionManager.download(downloadTask.getPkRequest().getTargetUrl(), localFile, TorrentFlags.NEED_SAVE_RESUME);
    }

    private final boolean checkProto(PKDownloadTask downloadTask) {
        String btUrl = downloadTask.getPkRequest().getTargetUrl();
        if (!StringsKt.startsWith((String)btUrl, (String)MAGNET_PROTO, (boolean)true)) {
            PKDownloadTask.fail$pikachu_release$default(downloadTask, "download url is invalid for BT-MAGNET!", null, 2, null);
            PKLog.INSTANCE.debug("\u78c1\u529b\u94fe\u63a5url:" + btUrl + "\u6821\u9a8c\u5931\u8d25");
            this.client.getPkDispatcher().complete(downloadTask);
            return false;
        }
        try {
            AddTorrentParams.parseMagnetUri((String)btUrl);
        }
        catch (Exception exception) {
            PKLog.INSTANCE.debug("\u78c1\u529b\u94fe\u63a5url:" + btUrl + "\u6821\u9a8c\u5931\u8d25");
            PKDownloadTask.fail$pikachu_release$default(downloadTask, "download url is invalid for BT-MAGNET!", null, 2, null);
            this.client.getPkDispatcher().complete(downloadTask);
            return false;
        }
        return true;
    }

    public PKMagnetDownloadEngine(@NotNull Pikachu client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.client = client;
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    public static final /* synthetic */ Handler access$getMainHandler$p(PKMagnetDownloadEngine $this) {
        return $this.mainHandler;
    }

    public static final /* synthetic */ Pikachu access$getClient$p(PKMagnetDownloadEngine $this) {
        return $this.client;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/damiao/pikachu/core/engine/PKMagnetDownloadEngine$Companion;", "", "()V", "MAGNET_PROTO", "", "pikachu_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

