/*
 * Decompiled with CFR 0.152.
 */
package com.damiao.pikachu.core.engine;

import android.os.Handler;
import android.os.Looper;
import com.damiao.pikachu.Pikachu;
import com.damiao.pikachu.common.PKDownloadTask;
import com.damiao.pikachu.common.PKDownloadTaskRequest;
import com.damiao.pikachu.common.PKLog;
import com.damiao.pikachu.common.PKTaskProcessListener;
import com.damiao.pikachu.core.engine.PKDownloadEngine;
import com.damiao.pikachu.core.exception.PKTaskCanceledException;
import com.damiao.pikachu.core.exception.PKTaskInterruptedException;
import com.damiao.pikachu.core.exception.PKTaskNeedReDownloadException;
import com.damiao.pikachu.util.PKCommonKt;
import java.io.Closeable;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J \u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/damiao/pikachu/core/engine/PKHttpDownloadEngine;", "Lcom/damiao/pikachu/core/engine/PKDownloadEngine;", "client", "Lcom/damiao/pikachu/Pikachu;", "okHttpClient", "Lokhttp3/OkHttpClient;", "(Lcom/damiao/pikachu/Pikachu;Lokhttp3/OkHttpClient;)V", "mainHandler", "Landroid/os/Handler;", "buildRequest", "Lokhttp3/Request;", "downloadTask", "Lcom/damiao/pikachu/common/PKDownloadTask;", "url", "Lokhttp3/HttpUrl;", "isAppendedDownload", "", "checkProto", "download", "", "needDbProgress", "readResponseAndWriteLocalFile", "httpRequest", "supportProto", "", "", "Companion", "pikachu_release"})
public final class PKHttpDownloadEngine
implements PKDownloadEngine {
    private final Handler mainHandler;
    private final Pikachu client;
    private final OkHttpClient okHttpClient;
    public static final long DEFAULT_CHUNK_SIZE = 4096L;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<String> supportProto() {
        return CollectionsKt.listOf((Object[])new String[]{"http", "https"});
    }

    @Override
    public boolean needDbProgress() {
        return false;
    }

    @Override
    public void download(@NotNull PKDownloadTask downloadTask) {
        Intrinsics.checkParameterIsNotNull((Object)downloadTask, (String)"downloadTask");
        HttpUrl httpUrl = this.checkProto(downloadTask);
        if (httpUrl == null) {
            return;
        }
        HttpUrl url = httpUrl;
        downloadTask.start$pikachu_release();
        boolean isAppendedDownload = downloadTask.getProgress() != 0L;
        Request okHttpRequest = this.buildRequest(downloadTask, url, isAppendedDownload);
        this.readResponseAndWriteLocalFile(downloadTask, okHttpRequest, isAppendedDownload);
    }

    private final HttpUrl checkProto(PKDownloadTask downloadTask) {
        PKDownloadTaskRequest downloadRequest = downloadTask.getPkRequest();
        HttpUrl url = HttpUrl.Companion.parse(downloadRequest.getTargetUrl());
        if (url == null) {
            PKDownloadTask.fail$pikachu_release$default(downloadTask, "download url is invalid for HTTP!", null, 2, null);
            this.client.getPkDispatcher().complete(downloadTask);
            return null;
        }
        return url;
    }

    private final Request buildRequest(PKDownloadTask downloadTask, HttpUrl url, boolean isAppendedDownload) {
        Request request;
        if (isAppendedDownload) {
            String range = "bytes=" + downloadTask.getProgress() + '-';
            PKLog.INSTANCE.debug("\u65ad\u70b9\u7eed\u4f20Range\u8303\u56f4 : " + range);
            request = new Request.Builder().url(url).header("Range", range).get().build();
        } else {
            request = new Request.Builder().url(url).get().build();
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void readResponseAndWriteLocalFile(PKDownloadTask downloadTask, Request httpRequest, boolean isAppendedDownload) {
        block26: {
            void bodySource;
            void targetBufferedSink;
            void fileSink;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
            objectRef2.element = null;
            Response response = null;
            Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
            objectRef3.element = null;
            try {
                response = this.okHttpClient.newCall(httpRequest).execute();
                if (response.code() != 200 && response.code() != 206) {
                    throw (Throwable)new RuntimeException("Download request return code " + response.code());
                }
                String fileName = (String)CollectionsKt.last((List)response.request().url().pathSegments());
                downloadTask.setDownloadFileName(fileName);
                String resourceTag = Response.header$default((Response)response, (String)"ETag", null, (int)2, null);
                Object object = downloadTask.getVersionTagId();
                boolean bl = false;
                boolean bl2 = false;
                if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
                    object = resourceTag;
                    bl = false;
                    bl2 = false;
                    if (!(object == null || StringsKt.isBlank((CharSequence)object)) && Intrinsics.areEqual((Object)downloadTask.getVersionTagId(), (Object)resourceTag) ^ true) {
                        Util.closeQuietly((Closeable)((Closeable)response));
                        downloadTask.setVersionTagId(resourceTag);
                        downloadTask.setProgress(0L);
                        throw (Throwable)new PKTaskNeedReDownloadException();
                    }
                }
                downloadTask.setVersionTagId(resourceTag);
                ResponseBody responseBody = response.body();
                if (responseBody == null) break block26;
                object = (Closeable)responseBody;
                bl = false;
                Throwable throwable = null;
                try {
                    ResponseBody it = (ResponseBody)object;
                    boolean bl3 = false;
                    if (!isAppendedDownload) {
                        downloadTask.setContentLength(it.contentLength());
                    }
                    PKLog.INSTANCE.debug("\u5f53\u524d\u4efb\u52a1\u9700\u8981\u4e0b\u8f7d\u7684\u5206\u7247\u5927\u5c0f\u4e3a" + PKCommonKt.getDownloadFileSizeDescription(it.contentLength()));
                    File targetFile = new File(downloadTask.getPkRequest().getLocalSinkFilePath(), fileName);
                    fileSink.element = isAppendedDownload ? Okio.appendingSink((File)targetFile) : Okio.sink$default((File)targetFile, (boolean)false, (int)1, null);
                    Sink sink = (Sink)fileSink.element;
                    targetBufferedSink.element = sink != null ? Okio.buffer((Sink)sink) : null;
                    this.mainHandler.post(new Runnable(this, isAppendedDownload, downloadTask, fileName, (Ref.ObjectRef)fileSink, (Ref.ObjectRef)targetBufferedSink, (Ref.ObjectRef)bodySource){
                        final /* synthetic */ PKHttpDownloadEngine this$0;
                        final /* synthetic */ boolean $isAppendedDownload$inlined;
                        final /* synthetic */ PKDownloadTask $downloadTask$inlined;
                        final /* synthetic */ String $fileName$inlined;
                        final /* synthetic */ Ref.ObjectRef $fileSink$inlined;
                        final /* synthetic */ Ref.ObjectRef $targetBufferedSink$inlined;
                        final /* synthetic */ Ref.ObjectRef $bodySource$inlined;
                        {
                            this.this$0 = pKHttpDownloadEngine;
                            this.$isAppendedDownload$inlined = bl;
                            this.$downloadTask$inlined = pKDownloadTask;
                            this.$fileName$inlined = string;
                            this.$fileSink$inlined = objectRef;
                            this.$targetBufferedSink$inlined = objectRef2;
                            this.$bodySource$inlined = objectRef3;
                        }

                        public final void run() {
                            PKTaskProcessListener pKTaskProcessListener = this.$downloadTask$inlined.getPkRequest().getTaskProcessListener();
                            if (pKTaskProcessListener != null) {
                                pKTaskProcessListener.onStart(this.$downloadTask$inlined);
                            }
                            Iterable $this$forEach$iv = PKHttpDownloadEngine.access$getClient$p(this.this$0).getPkGlobalTaskProcessListenerList();
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                PKTaskProcessListener listener = (PKTaskProcessListener)element$iv;
                                boolean bl = false;
                                listener.onStart(this.$downloadTask$inlined);
                            }
                        }
                    });
                    PKDownloadTask.triggerPersist$pikachu_release$default(downloadTask, false, 1, null);
                    long remainingSize = it.contentLength();
                    bodySource.element = it.source();
                    while (remainingSize != 0L) {
                        if (downloadTask.isCancel()) {
                            PKCommonKt.closeAll((Closeable)((Sink)fileSink.element), (Closeable)((BufferedSink)targetBufferedSink.element), (Closeable)((BufferedSource)bodySource.element));
                            this.client.getPkDispatcher().complete(downloadTask);
                            targetFile.delete();
                            throw (Throwable)new PKTaskCanceledException();
                        }
                        PKDownloadTask pKDownloadTask = downloadTask;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        synchronized (pKDownloadTask) {
                            boolean bl6 = false;
                            if (downloadTask.isPause()) {
                                PKDownloadTask $this$wait$iv = downloadTask;
                                boolean $i$f$wait = false;
                                $this$wait$iv.wait();
                                if (downloadTask.isCancel()) {
                                    PKCommonKt.closeAll((Closeable)((Sink)fileSink.element), (Closeable)((BufferedSink)targetBufferedSink.element), (Closeable)((BufferedSource)bodySource.element));
                                    this.client.getPkDispatcher().complete(downloadTask);
                                    targetFile.delete();
                                    throw (Throwable)new PKTaskCanceledException();
                                }
                                PKCommonKt.closeAll((Closeable)((Sink)fileSink.element), (Closeable)((BufferedSink)targetBufferedSink.element), (Closeable)((BufferedSource)bodySource.element));
                                throw (Throwable)new PKTaskInterruptedException();
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        byte[] array = null;
                        long readByteCount = remainingSize < 4096L ? remainingSize : 4096L;
                        BufferedSource bufferedSource = (BufferedSource)bodySource.element;
                        if (bufferedSource == null) {
                            Intrinsics.throwNpe();
                        }
                        array = bufferedSource.readByteArray(readByteCount);
                        remainingSize -= readByteCount;
                        byte[] byArray = array;
                        boolean bl7 = false;
                        byte[] byArray2 = byArray;
                        boolean bl8 = false;
                        if (!(!(byArray2.length == 0))) break;
                        BufferedSink bufferedSink = (BufferedSink)targetBufferedSink.element;
                        if (bufferedSink != null) {
                            bufferedSink.write(array);
                        }
                        BufferedSink bufferedSink2 = (BufferedSink)targetBufferedSink.element;
                        if (bufferedSink2 != null) {
                            bufferedSink2.flush();
                        }
                        downloadTask.changeProgress$pikachu_release(array.length);
                        this.mainHandler.post(new Runnable(it, this, isAppendedDownload, downloadTask, fileName, (Ref.ObjectRef)fileSink, (Ref.ObjectRef)targetBufferedSink, (Ref.ObjectRef)bodySource){
                            final /* synthetic */ ResponseBody $it;
                            final /* synthetic */ PKHttpDownloadEngine this$0;
                            final /* synthetic */ boolean $isAppendedDownload$inlined;
                            final /* synthetic */ PKDownloadTask $downloadTask$inlined;
                            final /* synthetic */ String $fileName$inlined;
                            final /* synthetic */ Ref.ObjectRef $fileSink$inlined;
                            final /* synthetic */ Ref.ObjectRef $targetBufferedSink$inlined;
                            final /* synthetic */ Ref.ObjectRef $bodySource$inlined;
                            {
                                this.$it = responseBody;
                                this.this$0 = pKHttpDownloadEngine;
                                this.$isAppendedDownload$inlined = bl;
                                this.$downloadTask$inlined = pKDownloadTask;
                                this.$fileName$inlined = string;
                                this.$fileSink$inlined = objectRef;
                                this.$targetBufferedSink$inlined = objectRef2;
                                this.$bodySource$inlined = objectRef3;
                            }

                            public final void run() {
                                PKTaskProcessListener pKTaskProcessListener = this.$downloadTask$inlined.getPkRequest().getTaskProcessListener();
                                if (pKTaskProcessListener != null) {
                                    pKTaskProcessListener.onProcess(this.$downloadTask$inlined.getProgress(), this.$it.contentLength(), this.$downloadTask$inlined);
                                }
                                Iterable $this$forEach$iv = PKHttpDownloadEngine.access$getClient$p(this.this$0).getPkGlobalTaskProcessListenerList();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    PKTaskProcessListener listener = (PKTaskProcessListener)element$iv;
                                    boolean bl = false;
                                    listener.onProcess(this.$downloadTask$inlined.getProgress(), this.$it.contentLength(), this.$downloadTask$inlined);
                                }
                            }
                        });
                    }
                    PKCommonKt.closeAll((Closeable)((Sink)fileSink.element), (Closeable)((BufferedSink)targetBufferedSink.element), (Closeable)((BufferedSource)bodySource.element));
                    downloadTask.setDownloadResultFile(targetFile);
                    PKLog.INSTANCE.debug("\u76ee\u6807\u6587\u4ef6" + downloadTask.getDownloadFileName() + "\u4e0b\u8f7d\u5b8c\u6210");
                    downloadTask.success$pikachu_release();
                    this.mainHandler.post(new Runnable(this, isAppendedDownload, downloadTask, fileName, (Ref.ObjectRef)fileSink, (Ref.ObjectRef)targetBufferedSink, (Ref.ObjectRef)bodySource){
                        final /* synthetic */ PKHttpDownloadEngine this$0;
                        final /* synthetic */ boolean $isAppendedDownload$inlined;
                        final /* synthetic */ PKDownloadTask $downloadTask$inlined;
                        final /* synthetic */ String $fileName$inlined;
                        final /* synthetic */ Ref.ObjectRef $fileSink$inlined;
                        final /* synthetic */ Ref.ObjectRef $targetBufferedSink$inlined;
                        final /* synthetic */ Ref.ObjectRef $bodySource$inlined;
                        {
                            this.this$0 = pKHttpDownloadEngine;
                            this.$isAppendedDownload$inlined = bl;
                            this.$downloadTask$inlined = pKDownloadTask;
                            this.$fileName$inlined = string;
                            this.$fileSink$inlined = objectRef;
                            this.$targetBufferedSink$inlined = objectRef2;
                            this.$bodySource$inlined = objectRef3;
                        }

                        public final void run() {
                            PKTaskProcessListener pKTaskProcessListener = this.$downloadTask$inlined.getPkRequest().getTaskProcessListener();
                            if (pKTaskProcessListener != null) {
                                pKTaskProcessListener.onComplete(this.$downloadTask$inlined);
                            }
                            Iterable $this$forEach$iv = PKHttpDownloadEngine.access$getClient$p(this.this$0).getPkGlobalTaskProcessListenerList();
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                PKTaskProcessListener listener = (PKTaskProcessListener)element$iv;
                                boolean bl = false;
                                listener.onComplete(this.$downloadTask$inlined);
                            }
                        }
                    });
                    this.client.getPkDispatcher().complete(downloadTask);
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (PKTaskNeedReDownloadException reDownloadException) {
                PKLog.INSTANCE.debug("\u76ee\u6807\u8d44\u6e90\u53d1\u751f\u4e86\u53d8\u66f4\uff0c\u9700\u8981\u91cd\u65b0\u4e0b\u8f7d\u8be5\u6587\u4ef6");
                this.download(downloadTask);
            }
            catch (PKTaskInterruptedException interruptedException) {
                PKLog.INSTANCE.debug("\u4efb\u52a1\u88ab\u4e2d\u65ad\uff0c\u9700\u8981\u91cd\u65b0\u5efa\u7acb\u8fde\u63a5\u7ee7\u7eed\u5411\u670d\u52a1\u5668\u4e0b\u8f7d\u6587\u4ef6");
                this.download(downloadTask);
            }
            catch (PKTaskCanceledException canceledException) {
                PKLog.INSTANCE.debug("\u4efb\u52a1\u88ab\u53d6\u6d88\uff0c\u505c\u6b62\u8be5\u4efb\u52a1\u7684\u4e0b\u8f7d");
                PKTaskProcessListener pKTaskProcessListener = downloadTask.getPkRequest().getTaskProcessListener();
                if (pKTaskProcessListener != null) {
                    pKTaskProcessListener.onCancel(downloadTask);
                }
                Iterable $this$forEach$iv = this.client.getPkGlobalTaskProcessListenerList();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PKTaskProcessListener listener = (PKTaskProcessListener)element$iv;
                    boolean bl = false;
                    listener.onCancel(downloadTask);
                }
                this.client.getPkDispatcher().complete(downloadTask);
            }
            catch (Exception e) {
                PKCommonKt.closeAll((Closeable)((Sink)fileSink.element), (Closeable)((BufferedSink)targetBufferedSink.element), (Closeable)((BufferedSource)bodySource.element), (Closeable)response);
                PKLog.INSTANCE.error("download fail " + e.getMessage());
                PKDownloadTask.fail$pikachu_release$default(downloadTask, "download execute fail by exception " + e.getMessage(), null, 2, null);
                this.client.getPkDispatcher().complete(downloadTask);
                this.mainHandler.post(new Runnable(this, downloadTask, e){
                    final /* synthetic */ PKHttpDownloadEngine this$0;
                    final /* synthetic */ PKDownloadTask $downloadTask;
                    final /* synthetic */ Exception $e;

                    public final void run() {
                        PKTaskProcessListener pKTaskProcessListener = this.$downloadTask.getPkRequest().getTaskProcessListener();
                        if (pKTaskProcessListener != null) {
                            pKTaskProcessListener.onFail("download execute fail by exception " + this.$e.getMessage(), this.$e, this.$downloadTask);
                        }
                        Iterable $this$forEach$iv = PKHttpDownloadEngine.access$getClient$p(this.this$0).getPkGlobalTaskProcessListenerList();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            PKTaskProcessListener listener = (PKTaskProcessListener)element$iv;
                            boolean bl = false;
                            listener.onFail("download execute fail by exception " + this.$e.getMessage(), this.$e, this.$downloadTask);
                        }
                    }
                    {
                        this.this$0 = pKHttpDownloadEngine;
                        this.$downloadTask = pKDownloadTask;
                        this.$e = exception;
                    }
                });
            }
        }
    }

    public PKHttpDownloadEngine(@NotNull Pikachu client, @NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
        this.client = client;
        this.okHttpClient = okHttpClient;
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    public /* synthetic */ PKHttpDownloadEngine(Pikachu pikachu, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            okHttpClient = new OkHttpClient();
        }
        this(pikachu, okHttpClient);
    }

    public static final /* synthetic */ Pikachu access$getClient$p(PKHttpDownloadEngine $this) {
        return $this.client;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/damiao/pikachu/core/engine/PKHttpDownloadEngine$Companion;", "", "()V", "DEFAULT_CHUNK_SIZE", "", "pikachu_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

