/*
 * Decompiled with CFR 0.152.
 */
package com.damiao.pikachu.common;

import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.damiao.pikachu.Pikachu;
import com.damiao.pikachu.common.PKDownloadTask;
import com.damiao.pikachu.common.PKDownloadTaskRequest;
import com.damiao.pikachu.common.PKLog;
import com.damiao.pikachu.common.PKRealDownloadTask;
import com.damiao.pikachu.common.PKTaskProcessListener;
import com.damiao.pikachu.core.engine.PKDownloadEngine;
import com.damiao.pikachu.util.PKCommonKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/damiao/pikachu/common/PKTaskParam;", "", "lifecycle", "Landroidx/lifecycle/LifecycleOwner;", "client", "Lcom/damiao/pikachu/Pikachu;", "url", "", "targetDirectorPath", "taskProcessListener", "Lcom/damiao/pikachu/common/PKTaskProcessListener;", "(Landroidx/lifecycle/LifecycleOwner;Lcom/damiao/pikachu/Pikachu;Ljava/lang/String;Ljava/lang/String;Lcom/damiao/pikachu/common/PKTaskProcessListener;)V", "checkArgs", "", "download", "Lcom/damiao/pikachu/common/PKDownloadTask;", "targetPath", "path", "listener", "pikachu_release"})
public final class PKTaskParam {
    private LifecycleOwner lifecycle;
    private final Pikachu client;
    private String url;
    private String targetDirectorPath;
    private PKTaskProcessListener taskProcessListener;

    @NotNull
    public final PKTaskParam url(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.url = url;
        return this;
    }

    @NotNull
    public final PKTaskParam targetPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.targetDirectorPath = path;
        return this;
    }

    @NotNull
    public final PKTaskParam taskProcessListener(@NotNull PKTaskProcessListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.taskProcessListener = listener;
        return this;
    }

    @Nullable
    public final PKDownloadTask download() {
        if (!this.checkArgs()) {
            return null;
        }
        PKDownloadEngine downloadEngine = this.client.getPkDownloadEngRegister().findDownloadEngine(this.url);
        if (downloadEngine == null) {
            PKLog.INSTANCE.error("can not find download engine for url : " + this.url);
            return null;
        }
        PKDownloadTaskRequest downloadRequest = new PKDownloadTaskRequest(this.url, this.targetDirectorPath, this.taskProcessListener);
        PKRealDownloadTask downloadTask = new PKRealDownloadTask(downloadRequest, PKCommonKt.uuid(), null, 4, null);
        downloadTask.setNeedDbProgress$pikachu_release(downloadEngine.needDbProgress());
        this.lifecycle.getLifecycle().addObserver((LifecycleObserver)downloadTask);
        this.client.getPkDispatcher().enqueue(downloadTask);
        return downloadTask;
    }

    private final boolean checkArgs() {
        if (StringsKt.isBlank((CharSequence)this.url)) {
            PKLog.INSTANCE.error("url can not be empty");
            return false;
        }
        if (StringsKt.isBlank((CharSequence)this.targetDirectorPath)) {
            PKLog.INSTANCE.error("targetDirectorPath can not be empty");
            return false;
        }
        File file = new File(this.targetDirectorPath);
        if (!file.exists()) {
            PKLog.INSTANCE.info("target directory not exist , pikachu will try to create");
            if (!file.mkdirs()) {
                PKLog.INSTANCE.error("create target directory fail, please ensure you have read/write storage permission");
                return false;
            }
        } else if (!file.isDirectory()) {
            PKLog.INSTANCE.error("targetDirectorPath must exists and is a directory");
            return false;
        }
        return true;
    }

    public PKTaskParam(@NotNull LifecycleOwner lifecycle, @NotNull Pikachu client, @NotNull String url, @NotNull String targetDirectorPath, @Nullable PKTaskProcessListener taskProcessListener) {
        Intrinsics.checkParameterIsNotNull((Object)lifecycle, (String)"lifecycle");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)targetDirectorPath, (String)"targetDirectorPath");
        this.lifecycle = lifecycle;
        this.client = client;
        this.url = url;
        this.targetDirectorPath = targetDirectorPath;
        this.taskProcessListener = taskProcessListener;
    }

    public /* synthetic */ PKTaskParam(LifecycleOwner lifecycleOwner, Pikachu pikachu, String string, String string2, PKTaskProcessListener pKTaskProcessListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "";
        }
        if ((n & 8) != 0) {
            string2 = "";
        }
        if ((n & 0x10) != 0) {
            pKTaskProcessListener = null;
        }
        this(lifecycleOwner, pikachu, string, string2, pKTaskProcessListener);
    }
}

