/*
 * Decompiled with CFR 0.152.
 */
package ru.xpoft.vaadin;

import com.vaadin.server.SystemMessages;
import com.vaadin.server.SystemMessagesInfo;
import com.vaadin.server.SystemMessagesProvider;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import ru.xpoft.vaadin.DefaultSpringSystemMessagesProvider;
import ru.xpoft.vaadin.SpringSystemMessagesProvider;

public class SpringVaadinSystemMessagesProvider
implements SystemMessagesProvider {
    public static final String DEFAULT_IMPLEMENTATION = "DEFAULT";
    private static Logger logger = LoggerFactory.getLogger(SpringVaadinSystemMessagesProvider.class);
    private final ConcurrentMap<Locale, SystemMessages> systemMessagesCache = new ConcurrentHashMap<Locale, SystemMessages>();
    private SpringSystemMessagesProvider systemMessagesBean;

    public SpringVaadinSystemMessagesProvider(ApplicationContext applicationContext, String systemMessagesBeanName) {
        if (systemMessagesBeanName.equals(DEFAULT_IMPLEMENTATION)) {
            MessageSource messageSource = (MessageSource)applicationContext.getBean(MessageSource.class);
            this.systemMessagesBean = new DefaultSpringSystemMessagesProvider();
            ((DefaultSpringSystemMessagesProvider)this.systemMessagesBean).setMessageSource(messageSource);
            logger.debug("use default systemMessagesBean");
        } else {
            this.systemMessagesBean = (SpringSystemMessagesProvider)applicationContext.getBean(systemMessagesBeanName, SpringSystemMessagesProvider.class);
        }
        logger.debug("get systemMessagesBean: {}", (Object)this.systemMessagesBean);
    }

    public SystemMessages getSystemMessages(SystemMessagesInfo systemMessagesInfo) {
        Locale locale = systemMessagesInfo.getLocale();
        if (this.systemMessagesCache.containsKey(locale)) {
            return (SystemMessages)this.systemMessagesCache.get(locale);
        }
        SystemMessages systemMessages = this.systemMessagesBean.getSystemMessages(locale);
        this.systemMessagesCache.put(locale, systemMessages);
        return systemMessages;
    }
}

