/*
 * Decompiled with CFR 0.152.
 */
package ru.xpoft.vaadin;

import com.vaadin.server.UIClassSelectionEvent;
import com.vaadin.server.UICreateEvent;
import com.vaadin.server.UIProvider;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.UI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.xpoft.vaadin.SpringApplicationContext;

public class SpringUIProvider
extends UIProvider {
    private static Logger logger = LoggerFactory.getLogger(SpringUIProvider.class);
    protected static final String BEAN_NAME_PARAMETER = "beanName";

    public UI createInstance(UICreateEvent event) {
        return (UI)SpringApplicationContext.getApplicationContext().getBean(this.getUIBeanName(event.getRequest()));
    }

    public Class<? extends UI> getUIClass(UIClassSelectionEvent event) {
        if (this.isSessionScopedUI(event.getRequest())) {
            logger.warn("You should use Prototype scope for UI only!");
        }
        return SpringApplicationContext.getApplicationContext().getType(this.getUIBeanName(event.getRequest()));
    }

    protected boolean isSessionScopedUI(VaadinRequest request) {
        return !SpringApplicationContext.getApplicationContext().isPrototype(this.getUIBeanName(request));
    }

    protected String getUIBeanName(VaadinRequest request) {
        String vaadinBeanName = "ui";
        String uiBeanName = request.getService().getDeploymentConfiguration().getApplicationOrSystemProperty(BEAN_NAME_PARAMETER, null);
        if (uiBeanName != null && uiBeanName instanceof String) {
            vaadinBeanName = uiBeanName.toString();
        }
        logger.debug("found BEAN_NAME_PARAMETER: {}", (Object)vaadinBeanName);
        return vaadinBeanName;
    }
}

