package cz.pumpitup.pn5.remote.samba;

import cz.pumpitup.pn5.core.CoreAccessor;
import cz.pumpitup.pn5.core.webdriver.ApplicationProxyInvocationHandler;
import cz.pumpitup.pn5.core.webdriver.WebDriverClientExtension;

import java.lang.reflect.Proxy;
import java.util.Map;

public class SambaClientExtension extends WebDriverClientExtension<SambaApplication> {

    public SambaClientExtension() { super(SambaApplication.class); }

    @Override
    protected SambaApplication createProxy(Class<? extends SambaApplication> type,
                                           String driverUrl,
                                           Map<String, Object> capabilities,
                                           CoreAccessor core) {
        String parameterTypeName = type.getSimpleName();
        if (!SambaApplication.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("%s type must extend SambaApplication", parameterTypeName));
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException(String.format("%s type must be an interface", parameterTypeName));
        }
        return (SambaApplication) Proxy.newProxyInstance(
                SambaAgentSupport.class.getClassLoader(),
                new Class[]{type},
                new ApplicationProxyInvocationHandler<SambaApplication>(
                        type,
                        new SambaApplicationSupport(
                                core,
                                driverUrl,
                                capabilities)));
    }
}
