package cz.pumpitup.pn5.remote.samba;

import cz.pumpitup.pn5.PumpoException;
import cz.pumpitup.pn5.core.CoreAccessor;
import cz.pumpitup.pn5.core.Logger;
import cz.pumpitup.pn5.core.webdriver.ApplicationSupport;
import cz.pumpitup.pn5.core.webdriver.RemoteDriverAgent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;

import static cz.pumpitup.pn5.core.LogLevel.ERROR;

public class SambaApplicationSupport extends ApplicationSupport<SambaApplication> implements SambaApplication {

    protected SambaAgentSupport agent;

    public SambaApplicationSupport(CoreAccessor core,
                                   String driverUrl,
                                   Map<String, Object> capabilities) {
        super(core, driverUrl, capabilities);
    }

    @Override
    protected void startSessionImplementation() {
        agent = newAgent();
    }

    @Override
    public SambaAgentSupport newAgent() {
        return new SambaAgentSupport(this, capabilities, driverUrl);
    }

    @Override
    public RemoteDriverAgent agent() {
        return agent;
    }

    @Override
    protected void closeSessionImplementation() {
        if (agent != null) {
            attemptClosingSession(agent);
            agent = null;
        }
    }

    @Override
    public SambaListResponse listFiles(String folder) {
        checkSessionStarted();
        return agent.listFiles(folder);
    }

    @Override
    public SambaWriteResponse createFolder(String folder) {
        checkSessionStarted();
        return agent.createFolder(folder);
    }

    @Override
    public SambaResponse deleteFolder(String folder, boolean recursive) {
        checkSessionStarted();
        return agent.deleteFolder(folder, recursive);
    }

    @Override
    public SambaWriteResponse writeFile(File file, String fileName) {
        checkSessionStarted();
        FileInputStream fileStream;
        try {
            fileStream = new FileInputStream(file);
        } catch (FileNotFoundException e) {
            Logger logger = getLogger();
            String message = String.format("File %s was not found", file);
            logger.log(ERROR, message);
            logger.log(ERROR, e.getMessage());
            throw new PumpoException(message, e);
        }
        return writeFile(fileStream, fileName);
    }

    @Override
    public SambaWriteResponse writeFile(InputStream fileStream, String fileName) {
        checkSessionStarted();
        return agent.writeFile(fileStream, fileName);
    }

    @Override
    public SambaReadResponse readFile(String file) {
        checkSessionStarted();
        return agent.readFile(file);
    }

    @Override
    public SambaWriteResponse moveFile(String oldFile, String newFile) {
        checkSessionStarted();
        return agent.moveFile(oldFile, newFile);
    }

    @Override
    public SambaResponse deleteFile(String file) {
        checkSessionStarted();
        return agent.deleteFile(file);
    }
}
