package cz.pumpitup.pn5.remote.samba;

import cz.pumpitup.pn5.core.util.Asserts;

import java.util.Date;

import static cz.pumpitup.pn5.core.LogLevel.INFO;
import static java.lang.String.format;

public class SambaWriteResponse extends SambaResponse {
    public String name;
    public long size;
    public Date creationTime;
    public Date modificationTime;
    public Date lastAccessTime;
    public Date lastWriteTime;

    public SambaWriteResponse printFileInformation() {
        sambaApplication.getLogger().log(
                INFO,
                "name: {}, size: {} bytes, creation time: {}, modification time: {}, last access time: {}, last write time: {}",
                name,
                size,
                creationTime,
                modificationTime,
                lastAccessTime,
                lastWriteTime
        );
        return this;
    }

    public SambaWriteResponse assertFileSizeInBytes(long fileSizeInBytes) {
        Asserts.assertTrue(format("File size is different. Expected: %d bytes, Actual: %d bytes", fileSizeInBytes, size), size == fileSizeInBytes);
        return this;
    }
}
