package cz.pumpitup.pn5.remote.samba;

import cz.pumpitup.pn5.core.util.Asserts;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

import static cz.pumpitup.pn5.core.LogLevel.INFO;

public class SambaListResponse extends SambaResponse {

    public Collection<Map<String, Object>> filesAndFolders;

    public SambaListResponse printFilesInformation() {
        filesAndFolders
                .forEach(file -> sambaApplication.getLogger().log(
                        INFO,
                        "name: {}, size: {} bytes, creation time: {}, modification time: {}, last access time: {}, last write time: {}",
                        file.get("name"),
                        file.get("size").toString(),
                        file.get("creationTime").toString(),
                        file.get("modificationTime").toString(),
                        file.get("lastAccessTime").toString(),
                        file.get("lastWriteTime").toString()
                ));
        return this;
    }

    public Collection<Map<String, Object>> getFilesAndFolders() {
        return this.filesAndFolders;
    }

    /**
     * Asserts that the returned list of elements in a folder does contain the specific file/folder.
     * @param fileOrFolder File or folder name to be searched in the list.
     */
    public SambaListResponse assertThatContainsFileOrFolderNamed(String fileOrFolder) {
        Asserts.assertContains(getFileNames(), fileOrFolder);
        return this;
    }

    /**
     * Asserts that the returned list of elements in a folder does not contain the specific file/folder.
     * @param fileOrFolder File or folder name to be searched in the list.
     */
    public SambaListResponse assertThatDoesNotContainFileOrFolderNamed(String fileOrFolder) {
        Asserts.assertDoesNotContain(getFileNames(), fileOrFolder);
        return this;
    }

    private Collection<String> getFileNames() {
        return this.filesAndFolders
                .stream()
                .map(file -> file.get("name").toString())
                .collect(Collectors.toList());
    }
}
