package cz.pumpitup.pn5.remote.samba;

import cz.pumpitup.pn5.core.CoreAccessor;
import cz.pumpitup.pn5.core.EndpointDsl;
import cz.pumpitup.pn5.core.SessionManager;

import java.io.File;
import java.io.InputStream;

public interface SambaApplication extends EndpointDsl, CoreAccessor, SambaDsl, SessionManager<SambaApplication> {

    // Folder operations
    SambaWriteResponse createFolder(String folder);

    SambaResponse deleteFolder(String folder, boolean recursive);

    SambaListResponse listFiles(String folder);


    // File operations
    SambaWriteResponse writeFile(File file, String fileName);

    SambaWriteResponse writeFile(InputStream fileStream, String fileName);

    SambaReadResponse readFile(String file);

    SambaWriteResponse moveFile(String oldFile, String newFile);

    SambaResponse deleteFile(String file);
}