/*
 * Decompiled with CFR 0.152.
 */
package cz.pumpitup.pn5.remote.samba;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import cz.pumpitup.pn5.PumpoException;
import cz.pumpitup.pn5.core.LogLevel;
import cz.pumpitup.pn5.core.Logger;
import cz.pumpitup.pn5.core.webdriver.AbstractRemoteDriverAgent;
import cz.pumpitup.pn5.remote.samba.SambaAgent;
import cz.pumpitup.pn5.remote.samba.SambaApplication;
import cz.pumpitup.pn5.remote.samba.SambaListResponse;
import cz.pumpitup.pn5.remote.samba.SambaReadResponse;
import cz.pumpitup.pn5.remote.samba.SambaResponse;
import cz.pumpitup.pn5.remote.samba.SambaWriteResponse;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;

public class SambaAgentSupport
extends AbstractRemoteDriverAgent
implements SambaAgent {
    private static final String CREATE_FOLDER = "samba_create_folder";
    private static final String DELETE_FOLDER = "samba_delete_folder";
    private static final String LIST_FILES = "samba_list_files";
    private static final String WRITE_FILE = "samba_write_file";
    private static final String READ_FILE = "samba_read_file";
    private static final String MOVE_FILE = "samba_move_file";
    private static final String DELETE_FILE = "samba_delete_file";
    private static final Map<String, CommandInfo> ADDITIONAL_COMMANDS = new HashMap<String, CommandInfo>();
    private static final ObjectMapper MAPPER;
    private final SambaApplication sambaApplication;

    public SambaAgentSupport(SambaApplication sambaApplication, Map<String, Object> capabilities, String farmUrl) {
        super(sambaApplication.getLogger(), capabilities, farmUrl);
        this.sambaApplication = sambaApplication;
    }

    protected Map<String, CommandInfo> getAdditionalCommands() {
        return ADDITIONAL_COMMANDS;
    }

    public SambaWriteResponse createFolder(String folder) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("folder", folder);
        Response response = this.driver.execute(CREATE_FOLDER, params);
        return this.parseResponse(response, SambaWriteResponse.class);
    }

    public SambaResponse deleteFolder(String folder, boolean recursive) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pathToFolder", folder);
        params.put("recursive", String.valueOf(recursive));
        Response response = this.driver.execute(DELETE_FOLDER, params);
        return this.parseResponse(response, SambaResponse.class);
    }

    public SambaListResponse listFiles(String folder) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pathToFolder", folder);
        Response response = this.driver.execute(LIST_FILES, params);
        return this.parseResponse(response, SambaListResponse.class);
    }

    public SambaWriteResponse writeFile(InputStream stream, String fileName) {
        String fileToString;
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            byte[] bytes = stream.readAllBytes();
            stream.close();
            fileToString = Base64.getEncoder().encodeToString(bytes);
        }
        catch (IOException e) {
            Logger logger = this.sambaApplication.getLogger();
            String message = "Error reading from provided stream";
            logger.log(LogLevel.ERROR, message, new Object[0]);
            logger.log(LogLevel.ERROR, e.getMessage(), new Object[0]);
            throw new PumpoException(message, (Throwable)e);
        }
        params.put("file", fileToString);
        params.put("fileName", fileName);
        Response response = this.driver.execute(WRITE_FILE, params);
        return this.parseResponse(response, SambaWriteResponse.class);
    }

    public SambaReadResponse readFile(String file) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pathToFile", file);
        Response response = this.driver.execute(READ_FILE, params);
        return this.parseResponse(response, SambaReadResponse.class);
    }

    public SambaWriteResponse moveFile(String oldFile, String newFile) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("oldFile", oldFile);
        params.put("newFile", newFile);
        Response response = this.driver.execute(MOVE_FILE, params);
        return this.parseResponse(response, SambaWriteResponse.class);
    }

    public SambaResponse deleteFile(String file) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pathToFile", file);
        Response response = this.driver.execute(DELETE_FILE, params);
        return this.parseResponse(response, SambaResponse.class);
    }

    private <T extends SambaResponse> T parseResponse(Response response, Class<T> clazz) {
        if (response == null) {
            throw new IllegalStateException("Failed to get a valid response from the remote driver");
        }
        try {
            SambaResponse parsedResponse = (SambaResponse)MAPPER.treeToValue((TreeNode)MAPPER.valueToTree(response.getValue()), clazz);
            if (parsedResponse == null) {
                parsedResponse = (SambaResponse)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            parsedResponse.setFullResponse(response);
            parsedResponse.sambaApplication = this.sambaApplication;
            return (T)parsedResponse;
        }
        catch (JsonProcessingException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        ADDITIONAL_COMMANDS.put(CREATE_FOLDER, new CommandInfo("/session/:sessionId/samba/create_folder", HttpMethod.POST));
        ADDITIONAL_COMMANDS.put(DELETE_FOLDER, new CommandInfo("/session/:sessionId/samba/delete_folder", HttpMethod.POST));
        ADDITIONAL_COMMANDS.put(LIST_FILES, new CommandInfo("/session/:sessionId/samba/list_files", HttpMethod.POST));
        ADDITIONAL_COMMANDS.put(WRITE_FILE, new CommandInfo("/session/:sessionId/samba/write_file", HttpMethod.POST));
        ADDITIONAL_COMMANDS.put(READ_FILE, new CommandInfo("/session/:sessionId/samba/read_file", HttpMethod.POST));
        ADDITIONAL_COMMANDS.put(MOVE_FILE, new CommandInfo("/session/:sessionId/samba/move_file", HttpMethod.POST));
        ADDITIONAL_COMMANDS.put(DELETE_FILE, new CommandInfo("/session/:sessionId/samba/delete_file", HttpMethod.POST));
        MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

