package cz.pumpitup.pn5.remote.samba;

import cz.pumpitup.pn5.core.util.Asserts;

import java.util.Date;

import static cz.pumpitup.pn5.core.LogLevel.INFO;
import static java.lang.String.format;

public class SambaReadResponse extends SambaResponse {
    public byte[] fileContent;
    public String name;
    public Date creationTime;
    public Date modificationTime;
    public Date lastAccessTime;
    public Date lastWriteTime;

    public SambaReadResponse printFileInformation() {
        sambaApplication.getLogger().log(
                INFO,
                "name: {}, size: {} bytes, creation time: {}, modification time: {}, last access time: {}, last write time: {}",
                name,
                fileContent.length,
                creationTime,
                modificationTime,
                lastAccessTime,
                lastWriteTime
        );
        return this;
    }

    public byte[] getFileContent() {
        return this.fileContent;
    }

    public SambaReadResponse assertFileSizeInBytes(long fileSizeInBytes) {
        Asserts.assertTrue(format("File size is different. Expected: %d bytes, Actual: %d bytes", fileSizeInBytes, fileContent.length), fileContent.length == fileSizeInBytes);
        return this;
    }
}
