/*
 * Decompiled with CFR 0.152.
 */
package cz.pumpitup.pn5.remote.samba;

import cz.pumpitup.pn5.PumpoException;
import cz.pumpitup.pn5.core.CoreAccessor;
import cz.pumpitup.pn5.core.LogLevel;
import cz.pumpitup.pn5.core.Logger;
import cz.pumpitup.pn5.core.webdriver.ApplicationSupport;
import cz.pumpitup.pn5.core.webdriver.RemoteDriverAgent;
import cz.pumpitup.pn5.remote.samba.SambaAgentSupport;
import cz.pumpitup.pn5.remote.samba.SambaApplication;
import cz.pumpitup.pn5.remote.samba.SambaListResponse;
import cz.pumpitup.pn5.remote.samba.SambaReadResponse;
import cz.pumpitup.pn5.remote.samba.SambaResponse;
import cz.pumpitup.pn5.remote.samba.SambaWriteResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;

public class SambaApplicationSupport
extends ApplicationSupport<SambaApplication>
implements SambaApplication {
    protected SambaAgentSupport agent;

    public SambaApplicationSupport(CoreAccessor core, String driverUrl, Map<String, Object> capabilities) {
        super(core, driverUrl, capabilities);
    }

    protected void startSessionImplementation() {
        this.agent = this.newAgent();
    }

    public SambaAgentSupport newAgent() {
        return new SambaAgentSupport(this, this.capabilities, this.driverUrl);
    }

    public RemoteDriverAgent agent() {
        return this.agent;
    }

    protected void closeSessionImplementation() {
        if (this.agent != null) {
            this.attemptClosingSession(this.agent);
            this.agent = null;
        }
    }

    @Override
    public SambaListResponse listFiles(String folder) {
        this.checkSessionStarted();
        return this.agent.listFiles(folder);
    }

    @Override
    public SambaWriteResponse createFolder(String folder) {
        this.checkSessionStarted();
        return this.agent.createFolder(folder);
    }

    @Override
    public SambaResponse deleteFolder(String folder, boolean recursive) {
        this.checkSessionStarted();
        return this.agent.deleteFolder(folder, recursive);
    }

    @Override
    public SambaWriteResponse writeFile(File file, String fileName) {
        FileInputStream fileStream;
        this.checkSessionStarted();
        try {
            fileStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            Logger logger = this.getLogger();
            String message = String.format("File %s was not found", file);
            logger.log(LogLevel.ERROR, message, new Object[0]);
            logger.log(LogLevel.ERROR, e.getMessage(), new Object[0]);
            throw new PumpoException(message, (Throwable)e);
        }
        return this.writeFile(fileStream, fileName);
    }

    @Override
    public SambaWriteResponse writeFile(InputStream fileStream, String fileName) {
        this.checkSessionStarted();
        return this.agent.writeFile(fileStream, fileName);
    }

    @Override
    public SambaReadResponse readFile(String file) {
        this.checkSessionStarted();
        return this.agent.readFile(file);
    }

    @Override
    public SambaWriteResponse moveFile(String oldFile, String newFile) {
        this.checkSessionStarted();
        return this.agent.moveFile(oldFile, newFile);
    }

    @Override
    public SambaResponse deleteFile(String file) {
        this.checkSessionStarted();
        return this.agent.deleteFile(file);
    }
}

