/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.PointD;
import cz.mzk.tiledimageview.R;
import cz.mzk.tiledimageview.TiledImageViewApi;
import cz.mzk.tiledimageview.Utils;
import cz.mzk.tiledimageview.VectorD;
import cz.mzk.tiledimageview.dev.DevLoggers;
import cz.mzk.tiledimageview.dev.DevPoints;
import cz.mzk.tiledimageview.dev.DevTools;
import cz.mzk.tiledimageview.gestures.MyGestureListener;
import cz.mzk.tiledimageview.images.ImageManager;
import cz.mzk.tiledimageview.images.TilePositionInPyramid;
import cz.mzk.tiledimageview.images.TiledImageProtocol;
import cz.mzk.tiledimageview.images.cache.CacheManager;
import cz.mzk.tiledimageview.images.metadata.ImageMetadata;
import cz.mzk.tiledimageview.images.tasks.TaskManager;
import cz.mzk.tiledimageview.images.zoomify.ZoomifyImageManager;
import cz.mzk.tiledimageview.rectangles.FramingRectangle;
import cz.mzk.tiledimageview.rectangles.FramingRectangleDrawer;
import java.util.List;

public class TiledImageView
extends View
implements TiledImageViewApi {
    public static final boolean DEV_LOGS = false;
    private static final Logger LOGGER = new Logger(TiledImageView.class);
    private boolean mAttachedToWindow = false;
    private boolean mVisible = false;
    private boolean mLowerQuality = false;
    private boolean mMinZoomCanvasImagePaddingInitialized = false;
    private boolean mHelpersInitialized = false;
    private double mCanvasImagePaddingHorizontal = -1.0;
    private double mCanvasImagePaddingVertical = -1.0;
    private Rect mWholeImageAreaInCanvasCoords = null;
    private Rect mVisibleImageAreaInCanvas = null;
    private boolean mViewmodeScaleFactorsInitialized = false;
    private double mPxRatio;
    private boolean mViewmodeShiftInitialized = false;
    private VectorD mViewmodeShift = VectorD.ZERO_VECTOR;
    private double mInitialScaleFactor = -1.0;
    private double mMinScaleFactor = -1.0;
    private double mMaxScaleFactor = -1.0;
    private ViewMode mViewMode = ViewMode.FIT_IN_VIEW;
    private TiledImageProtocol mtiledImageProtocol;
    private String mImageBaseUrl;
    private ImageManager mImageManager;
    private MetadataInitializationListener mMetadataInitializationListener;
    private TileDownloadErrorListener mTileDownloadErrorListener;
    private MyGestureListener mGestureListener;
    private SingleTapListener mSingleTapListener;
    private FramingRectangleDrawer mFramingRectDrawer;
    private boolean mShowDevVisualisations = false;
    private DevTools mDevTools = null;
    private DevPoints mTestPoints = null;

    public TiledImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LOGGER.i(this.buildMethodLog("constructor(Context,AttributeSet)"));
        this.processAttrs(context, attrs);
        this.initHelpers();
        this.logDeviceScreenCategory();
        this.logHwAcceleration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.cz_mzk_tiledimageview_TiledImageView, 0, 0);
        try {
            this.mShowDevVisualisations = a.getBoolean(R.styleable.cz_mzk_tiledimageview_TiledImageView_show_dev_visualisations, false);
            int viewModeId = a.getInt(R.styleable.cz_mzk_tiledimageview_TiledImageView_view_mode, 0);
            this.mViewMode = ViewMode.values()[viewModeId];
        }
        finally {
            a.recycle();
        }
    }

    public TiledImageView(Context context, boolean showDevVisualisations, ViewMode viewMode) {
        super(context);
        LOGGER.i(this.buildMethodLog("constructor(Context)"));
        this.mShowDevVisualisations = showDevVisualisations;
        this.mViewMode = viewMode;
        this.initHelpers();
        this.logDeviceScreenCategory();
        this.logHwAcceleration();
    }

    public TiledImageView(Context context, boolean showDevVisualisations) {
        this(context, showDevVisualisations, ViewMode.FIT_IN_VIEW);
    }

    public TiledImageView(Context context, ViewMode viewMode) {
        this(context, false, viewMode);
    }

    public TiledImageView(Context context) {
        this(context, false, ViewMode.FIT_IN_VIEW);
    }

    private String buildMethodLog(String method) {
        return method;
    }

    private void init(Context context) {
        LOGGER.i(this.buildMethodLog("init"));
        this.mPxRatio = (double)this.getResources().getInteger(R.integer.tiledimageview_pxRatio) / 100.0;
        if (this.mImageBaseUrl != null && this.mImageManager != null) {
            this.initImageManager();
        } else {
            if (this.mImageBaseUrl == null) {
                LOGGER.d(this.buildMethodLog("init: mImageBaseUrl is null"));
            }
            if (this.mImageManager == null) {
                LOGGER.d(this.buildMethodLog("init: mImageManager is null"));
            }
        }
    }

    private void initCache(final Context context) {
        LOGGER.i(this.buildMethodLog("initCache"));
        if (!CacheManager.isInitialized()) {
            Resources res = context.getResources();
            boolean diskCacheEnabled = res.getBoolean(R.bool.tiledimageview_disk_cache_enabled);
            boolean clearDiskCacheOnStart = res.getBoolean(R.bool.tiledimageview_disk_cache_clear_in_initialization);
            long tileDiskCacheBytes = res.getInteger(R.integer.tiledimageview_tile_disk_cache_size_kb) * 1024;
            TaskManager.enqueueCacheManagerInitialization(context, diskCacheEnabled, clearDiskCacheOnStart, tileDiskCacheBytes, new TaskManager.TaskListener(){

                @Override
                public void onFinished(Object ... data) {
                    if (TiledImageView.this.mAttachedToWindow) {
                        TiledImageView.this.init(context);
                    }
                }

                @Override
                public void onCanceled() {
                    if (TiledImageView.this.mAttachedToWindow) {
                        TiledImageView.this.initCache(context);
                    }
                }
            });
        } else {
            this.init(context);
        }
    }

    private void logDeviceScreenCategory() {
        String screenType = this.getResources().getString(R.string.tiledimageview_screen_type);
        DevLoggers.DISPLAY.d("screen type: " + screenType);
        double pixelRatio = (double)this.getResources().getInteger(R.integer.tiledimageview_pxRatio) / 100.0;
        DevLoggers.DISPLAY.d(String.format("pxRatio: %.2f", pixelRatio));
    }

    @SuppressLint(value={"NewApi"})
    private void logHwAcceleration() {
        if (Build.VERSION.SDK_INT >= 11) {
            DevLoggers.DISPLAY.d("(Window) HW accelerated: " + this.isHardwareAccelerated());
        }
    }

    @Override
    public ViewMode getViewMode() {
        return this.mViewMode;
    }

    @Override
    public void setViewMode(ViewMode viewMode) {
        if (viewMode == null) {
            throw new NullPointerException();
        }
        this.mViewMode = viewMode;
    }

    @Override
    public void setMetadataInitializationListener(MetadataInitializationListener listener) {
        LOGGER.d(this.buildMethodLog("setMetadataInitializationListener"));
        this.mMetadataInitializationListener = listener;
    }

    @Override
    public void setTileDownloadErrorListener(TileDownloadErrorListener errorListener) {
        this.mTileDownloadErrorListener = errorListener;
    }

    @Override
    public void setLowerQuality(boolean lowerQuality) {
        this.mLowerQuality = lowerQuality;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.initHelpers();
        this.mAttachedToWindow = true;
        LOGGER.i(this.buildMethodLog("onAttachedToWindow"));
        boolean bl = this.mVisible = this.getVisibility() == 0;
        if (this.mImageBaseUrl != null) {
            this.mImageManager = this.constructImageManager();
        }
        this.initCache(this.getContext());
    }

    private void initHelpers() {
        LOGGER.d(this.buildMethodLog("initHelpers"));
        if (!this.mHelpersInitialized) {
            if (this.mShowDevVisualisations) {
                this.mDevTools = new DevTools(this.getContext());
            }
            this.mGestureListener = new MyGestureListener(this.getContext(), this, this.mDevTools);
            this.mFramingRectDrawer = new FramingRectangleDrawer(this.getContext());
            this.mHelpersInitialized = true;
        }
    }

    private void clearHelpers() {
        LOGGER.d(this.buildMethodLog("clearHelpers"));
        this.mHelpersInitialized = false;
        if (this.mGestureListener != null) {
            this.mGestureListener.stopAllAnimations();
            this.mGestureListener = null;
        }
        this.mFramingRectDrawer = null;
        this.mDevTools = null;
    }

    protected void onDetachedFromWindow() {
        LOGGER.i(this.buildMethodLog("ondDetachedFromWindow"));
        this.mAttachedToWindow = false;
        if (this.mImageManager != null) {
            this.mImageManager.cancelAllTasks();
            this.mImageManager = null;
        }
        this.clearHelpers();
        this.mSingleTapListener = null;
        this.mMetadataInitializationListener = null;
        this.mTileDownloadErrorListener = null;
        super.onDetachedFromWindow();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        LOGGER.i(this.buildMethodLog("onVisibilityChanged: " + Utils.visibilityToString(visibility)));
        this.mVisible = visibility == 0;
        this.invalidate();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        boolean visible;
        super.onWindowVisibilityChanged(visibility);
        LOGGER.i(this.buildMethodLog("onWindowVisibilityChanged: " + Utils.visibilityToString(visibility)));
        boolean bl = visible = visibility == 0;
        if (!visible) {
            this.mVisible = false;
        }
        this.invalidate();
    }

    @Override
    public void loadImage(TiledImageProtocol tiledImageProtocol, String baseUrl) {
        LOGGER.d(this.buildMethodLog("loadImage: " + baseUrl));
        this.mViewmodeScaleFactorsInitialized = false;
        this.mViewmodeShiftInitialized = false;
        this.mMinZoomCanvasImagePaddingInitialized = false;
        this.mImageBaseUrl = baseUrl;
        this.mtiledImageProtocol = tiledImageProtocol;
        if (this.mGestureListener != null) {
            this.mGestureListener.reset();
        }
        if (CacheManager.isInitialized()) {
            if (this.mImageManager != null) {
                this.mImageManager.cancelAllTasks();
            }
            this.mImageManager = this.constructImageManager();
            this.initImageManager();
        }
    }

    private ImageManager constructImageManager() {
        switch (this.mtiledImageProtocol) {
            case ZOOMIFY: {
                return new ZoomifyImageManager(this.mImageBaseUrl, this.mPxRatio);
            }
        }
        throw new RuntimeException("unknown protocol " + this.mtiledImageProtocol.name());
    }

    private void initImageManager() {
        LOGGER.d(this.buildMethodLog("initImageManager"));
        final ImageManager imgManagerUsed = this.mImageManager;
        ImageMetadata metadata = this.mImageManager.getMetadata(new MetadataInitializationSuccessListener(){

            @Override
            public void onMetadataFetched(ImageMetadata metadata) {
                LOGGER.i(TiledImageView.this.buildMethodLog("initImageManager: metadata fetched"));
                if (imgManagerUsed.equals(TiledImageView.this.mImageManager)) {
                    TiledImageView.this.initImageManager(metadata);
                } else {
                    LOGGER.d(TiledImageView.this.buildMethodLog("initImageManager: ImageManager instance changed, ignoring"));
                }
            }
        }, this.mMetadataInitializationListener);
        if (metadata != null) {
            LOGGER.d(this.buildMethodLog("initImageManager: metadata!=null"));
            this.initImageManager(metadata);
            this.mMetadataInitializationListener.onMetadataInitialized();
        } else {
            LOGGER.d(this.buildMethodLog("initImageManager: metadata==null"));
        }
    }

    private void initImageManager(ImageMetadata metadata) {
        LOGGER.d(this.buildMethodLog("initImageManager (with metadata)"));
        this.mImageManager.init(metadata);
        if (this.mShowDevVisualisations) {
            this.mTestPoints = new DevPoints(this.mImageManager.getImageWidth(), this.mImageManager.getImageHeight());
        }
    }

    @Override
    public void setFramingRectangles(List<FramingRectangle> framingRectangles) {
        this.mFramingRectDrawer.setFrameRectangles(framingRectangles);
        this.invalidate();
    }

    public void onDraw(Canvas canv) {
        if (this.mDevTools != null) {
            this.mDevTools.setCanvas(canv);
        }
        if (this.mImageManager != null && this.mImageManager.isInitialized()) {
            int bestLayerId;
            if (this.mDevTools != null) {
                // empty if block
            }
            if (!this.mViewmodeScaleFactorsInitialized) {
                this.initViewmodeScaleFactors(canv);
                this.mViewmodeScaleFactorsInitialized = true;
            }
            if (!this.mViewmodeShiftInitialized) {
                this.initViewmodeShift(canv);
                this.mViewmodeShiftInitialized = true;
            }
            if (!this.mMinZoomCanvasImagePaddingInitialized) {
                this.initMinZoomPadding(canv);
                this.mMinZoomCanvasImagePaddingInitialized = true;
            }
            this.mWholeImageAreaInCanvasCoords = this.computeWholeImageAreaInCanvasCoords(this.getTotalScaleFactor(), this.getTotalShift());
            if (this.mDevTools != null) {
                this.mDevTools.fillRectAreaWithColor(this.mWholeImageAreaInCanvasCoords, this.mDevTools.getPaintRedTrans());
            }
            this.mVisibleImageAreaInCanvas = this.computeVisibleImageAreaInCanvas(canv);
            if (this.mDevTools != null) {
                this.mDevTools.fillRectAreaWithColor(this.mVisibleImageAreaInCanvas, this.mDevTools.getPaintGreenTrans());
            }
            if (!this.mVisible) {
                bestLayerId = 0;
            } else {
                bestLayerId = this.mImageManager.computeBestLayerId(this.mWholeImageAreaInCanvasCoords);
                if (this.mLowerQuality && bestLayerId > 1) {
                    --bestLayerId;
                }
            }
            this.mImageManager.cancelFetchingAllTilesForLayersBiggerThan(bestLayerId);
            this.drawTiles(canv, bestLayerId, true, this.calculateVisibleAreaInImageCoords());
            if (this.mFramingRectDrawer != null) {
                this.mFramingRectDrawer.setCanvas(canv);
                this.mFramingRectDrawer.draw(this.getTotalScaleFactor(), this.getTotalShift());
            }
            if (this.mDevTools != null) {
                double totalScaleFactor = this.getTotalScaleFactor();
                VectorD totalShift = this.getTotalShift();
                this.mDevTools.drawImageCoordPoints(this.mTestPoints, totalScaleFactor, totalShift);
                this.mDevTools.drawTileRectStack();
            }
        }
    }

    private void initViewmodeScaleFactors(Canvas canv) {
        int imgWidth = this.mImageManager.getImageWidth();
        int imgHeight = this.mImageManager.getImageHeight();
        double scaleFactorFitToScreen = this.computeScaleFactorFitToScreen(canv.getWidth(), canv.getHeight(), imgWidth, imgHeight);
        double scaleFactorNoFreeSpace = this.computeScaleFactorNoFreeSpace(canv.getWidth(), canv.getHeight(), imgWidth, imgHeight);
        switch (this.mViewMode) {
            case FIT_IN_VIEW: {
                this.mInitialScaleFactor = scaleFactorFitToScreen;
                break;
            }
            default: {
                this.mInitialScaleFactor = scaleFactorNoFreeSpace;
            }
        }
        this.mMinScaleFactor = Math.min(scaleFactorFitToScreen, scaleFactorNoFreeSpace);
        int mustFitInCanvasObjectWidthPx = this.mImageManager.getTileTypicalSize();
        int mustFitInCanvasObjectHeightPx = this.mImageManager.getTileTypicalSize();
        double maxWidthScalePx = (double)canv.getWidth() / (double)mustFitInCanvasObjectWidthPx;
        double maxHeightScalePx = (double)canv.getHeight() / (double)mustFitInCanvasObjectHeightPx;
        this.mMaxScaleFactor = Math.min(maxWidthScalePx, maxHeightScalePx);
    }

    private PointD computeVisibleImageCenter() {
        float x = this.mVisibleImageAreaInCanvas.width() / 2 + this.mVisibleImageAreaInCanvas.left;
        float y = this.mVisibleImageAreaInCanvas.height() / 2 + this.mVisibleImageAreaInCanvas.top;
        return new PointD(x, y);
    }

    @Override
    public double getCanvasImagePaddingHorizontal() {
        return this.mCanvasImagePaddingHorizontal;
    }

    @Override
    public double getCanvasImagePaddingVertical() {
        return this.mCanvasImagePaddingVertical;
    }

    @Override
    public VectorD getTotalShift() {
        VectorD gestureShifts = this.mGestureListener.getTotalShift();
        return this.mViewmodeShift.plus(gestureShifts);
    }

    @Override
    public double getTotalScaleFactor() {
        return this.mInitialScaleFactor * this.mGestureListener.getTotalScaleFactor();
    }

    @Override
    public double getMinScaleFactor() {
        return this.mMinScaleFactor;
    }

    @Override
    public double getMaxScaleFactor() {
        return this.mMaxScaleFactor;
    }

    private void drawTiles(Canvas canv, int layer, boolean isIdealLayer, Rect visibleAreaInImageCoords) {
        List<TilePositionInPyramid> visibleTilesInThisLayer = this.mImageManager.getVisibleTilesForLayer(layer, visibleAreaInImageCoords);
        this.mImageManager.cancelFetchingTilesForLayerExeptForThese(layer, visibleTilesInThisLayer);
        if (isIdealLayer) {
            this.mImageManager.inflateTilesMemoryCache(visibleTilesInThisLayer.size() * 2);
        }
        boolean allTilesAvailable = true;
        for (TilePositionInPyramid visibleTile : visibleTilesInThisLayer) {
            if (this.mImageManager.tileIsAvailableNow(visibleTile)) continue;
            allTilesAvailable = false;
            break;
        }
        if (!allTilesAvailable && layer != 0) {
            this.drawTiles(canv, layer - 1, false, visibleAreaInImageCoords);
        }
        boolean allTilesDrawn = true;
        for (TilePositionInPyramid visibleTile : visibleTilesInThisLayer) {
            Bitmap bitmap = this.mImageManager.getTile(visibleTile, new TileDownloadSuccessListener(){

                @Override
                public void onTileDelivered() {
                    TiledImageView.this.invalidate();
                }
            }, this.mTileDownloadErrorListener);
            if (bitmap != null) {
                this.drawTile(canv, visibleTile, bitmap);
                continue;
            }
            allTilesDrawn = false;
        }
        if (allTilesDrawn) {
            if (layer != 0) {
                this.mImageManager.cancelFetchingAllTilesForLayersSmallerThan(layer);
            }
        } else {
            this.invalidate();
        }
    }

    private void drawTile(Canvas canv, TilePositionInPyramid tileId, Bitmap tileBmp) {
        Rect tileInCanvas = this.toTileAreaInCanvas(tileId, tileBmp);
        canv.drawBitmap(tileBmp, null, tileInCanvas, null);
        if (this.mDevTools != null) {
            this.mDevTools.highlightTile(tileInCanvas, this.mDevTools.getPaintRed());
        }
    }

    private Rect calculateVisibleAreaInImageCoords() {
        double resizeFactor = this.getTotalScaleFactor();
        VectorD totalShift = this.getTotalShift();
        return Utils.toImageCoords(this.mVisibleImageAreaInCanvas, resizeFactor, totalShift);
    }

    private Rect toTileAreaInCanvas(TilePositionInPyramid tilePositionInPyramid, Bitmap tile) {
        Rect tileAreaInImageCoords = this.mImageManager.getTileAreaInImageCoords(tilePositionInPyramid);
        return Utils.toCanvasCoords(tileAreaInImageCoords, this.getTotalScaleFactor(), this.getTotalShift());
    }

    private double computeScaleFactorFitToScreen(double canvasWidth, double canvasHeight, double imgOriginalWidth, double imgOriginalHeight) {
        double widthRatio = canvasWidth / imgOriginalWidth;
        double heightRatio = canvasHeight / imgOriginalHeight;
        if (widthRatio < 1.0 && heightRatio < 1.0) {
            return widthRatio < heightRatio ? widthRatio : heightRatio;
        }
        if (widthRatio < 1.0) {
            return widthRatio;
        }
        if (heightRatio < 1.0) {
            return heightRatio;
        }
        return widthRatio < heightRatio ? widthRatio : heightRatio;
    }

    private double computeScaleFactorNoFreeSpace(double canvasWidth, double canvasHeight, double imgOriginalWidth, double imgOriginalHeight) {
        double widthRatio = canvasWidth / imgOriginalWidth;
        double heightRatio = canvasHeight / imgOriginalHeight;
        if (widthRatio < 1.0 && heightRatio < 1.0) {
            return widthRatio < heightRatio ? heightRatio : widthRatio;
        }
        if (heightRatio > 1.0) {
            return heightRatio;
        }
        if (widthRatio > 1.0) {
            return widthRatio;
        }
        return widthRatio > heightRatio ? widthRatio : heightRatio;
    }

    private void initViewmodeShift(Canvas canv) {
        double canvasWidth = canv.getWidth();
        double canvasHeight = canv.getHeight();
        double imageOriginalWidth = this.mImageManager.getImageWidth();
        double imageOriginalHeight = this.mImageManager.getImageHeight();
        double actualWidth = imageOriginalWidth * this.mInitialScaleFactor;
        double actualHeight = imageOriginalHeight * this.mInitialScaleFactor;
        double extraSpaceWidthCanv = canvasWidth - actualWidth;
        double extraSpaceHeightCanv = canvasHeight - actualHeight;
        double xLeft = 0.0;
        double xCenter = extraSpaceWidthCanv / 2.0;
        double xRight = extraSpaceWidthCanv;
        double yTop = 0.0;
        double yCenter = extraSpaceHeightCanv / 2.0;
        double yBottom = extraSpaceHeightCanv;
        switch (this.mViewMode) {
            case FIT_IN_VIEW: {
                this.mViewmodeShift = new VectorD(xCenter, yCenter);
                break;
            }
            case FILL_VIEW_ALIGN_LEFT_TOP: {
                this.mViewmodeShift = new VectorD(xLeft, yTop);
                break;
            }
            case FILL_VIEW_ALIGN_LEFT_CENTER: {
                this.mViewmodeShift = new VectorD(xLeft, yCenter);
                break;
            }
            case FILL_VIEW_ALIGN_LEFT_BOTTOM: {
                this.mViewmodeShift = new VectorD(xLeft, yBottom);
                break;
            }
            case FILL_VIEW_ALIGN_CENTER_TOP: {
                this.mViewmodeShift = new VectorD(xCenter, yTop);
                break;
            }
            case FILL_VIEW_ALIGN_CENTER_CENTER: {
                this.mViewmodeShift = new VectorD(xCenter, yCenter);
                break;
            }
            case FILL_VIEW_ALIGN_CENTER_BOTTOM: {
                this.mViewmodeShift = new VectorD(xCenter, yBottom);
                break;
            }
            case FILL_VIEW_ALIGN_RIGHT_TOP: {
                this.mViewmodeShift = new VectorD(xRight, yTop);
                break;
            }
            case FILL_VIEW_ALIGN_RIGHT_CENTER: {
                this.mViewmodeShift = new VectorD(xRight, yCenter);
                break;
            }
            case FILL_VIEW_ALIGN_RIGHT_BOTTOM: {
                this.mViewmodeShift = new VectorD(xRight, yBottom);
            }
        }
        DevLoggers.CENTERS.d("initial shift:" + this.mViewmodeShift);
    }

    private void initMinZoomPadding(Canvas canv) {
        PointD imgBottomRight = new PointD(this.mImageManager.getImageWidth(), this.mImageManager.getImageHeight());
        PointD imgInCanvasBottomRight = Utils.toCanvasCoords(imgBottomRight, this.mMinScaleFactor, VectorD.ZERO_VECTOR);
        double freeWidth = ((double)canv.getWidth() - imgInCanvasBottomRight.x) * 0.5;
        double freeHeight = ((double)canv.getHeight() - imgInCanvasBottomRight.y) * 0.5;
        this.mCanvasImagePaddingHorizontal = Utils.toXInImageCoords(freeWidth, this.mMinScaleFactor, 0.0);
        this.mCanvasImagePaddingVertical = Utils.toYInImageCoords(freeHeight, this.mMinScaleFactor, 0.0);
    }

    private Rect computeWholeImageAreaInCanvasCoords(double scaleFactor, VectorD shift) {
        Rect imgArea = new Rect(0, 0, this.mImageManager.getImageWidth(), this.mImageManager.getImageHeight());
        return Utils.toCanvasCoords(imgArea, scaleFactor, shift);
    }

    private Rect computeVisibleImageAreaInCanvas(Canvas canv) {
        int left = this.mapNumberToInterval(this.mWholeImageAreaInCanvasCoords.left, 0, canv.getWidth());
        int right = this.mapNumberToInterval(this.mWholeImageAreaInCanvasCoords.right, 0, canv.getWidth());
        int top = this.mapNumberToInterval(this.mWholeImageAreaInCanvasCoords.top, 0, canv.getHeight());
        int bottom = this.mapNumberToInterval(this.mWholeImageAreaInCanvasCoords.bottom, 0, canv.getHeight());
        return new Rect(left, top, right, bottom);
    }

    private int mapNumberToInterval(int number, int min, int max) {
        if (number <= min) {
            return min;
        }
        if (number >= max) {
            return max;
        }
        return number;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.mGestureListener.onTouchEvent(event);
    }

    @Override
    public SingleTapListener getSingleTapListener() {
        return this.mSingleTapListener;
    }

    @Override
    public void setSingleTapListener(SingleTapListener singleTapListener) {
        this.mSingleTapListener = singleTapListener;
    }

    @Override
    public Rect getVisibleImageAreaInCanvas() {
        return this.mVisibleImageAreaInCanvas;
    }

    @Override
    public double getInitialScaleFactor() {
        return this.mInitialScaleFactor;
    }

    @Override
    public int getImageWidth() {
        if (this.mImageManager != null && this.mImageManager.isInitialized()) {
            return this.mImageManager.getImageWidth();
        }
        return 0;
    }

    @Override
    public int getImageHeight() {
        if (this.mImageManager != null && this.mImageManager.isInitialized()) {
            return this.mImageManager.getImageHeight();
        }
        return 0;
    }

    public static interface MetadataInitializationSuccessListener {
        public void onMetadataFetched(ImageMetadata var1);
    }

    public static interface TileDownloadSuccessListener {
        public void onTileDelivered();
    }

    public static interface TileDownloadErrorListener {
        public void onTileUnhandableResponse(String var1, int var2);

        public void onTileRedirectionLoop(String var1, int var2);

        public void onTileDataTransferError(String var1, String var2);

        public void onTileInvalidDataError(String var1, String var2);
    }

    public static interface MetadataInitializationListener {
        public void onMetadataInitialized();

        public void onMetadataUnhandableResponseCode(String var1, int var2);

        public void onMetadataRedirectionLoop(String var1, int var2);

        public void onMetadataDataTransferError(String var1, String var2);

        public void onMetadataInvalidData(String var1, String var2);

        public void onCannotExecuteMetadataInitialization(String var1);
    }

    public static interface SingleTapListener {
        public void onSingleTap(float var1, float var2, Rect var3);
    }

    public static enum ViewMode {
        FIT_IN_VIEW,
        FILL_VIEW_ALIGN_LEFT_TOP,
        FILL_VIEW_ALIGN_LEFT_CENTER,
        FILL_VIEW_ALIGN_LEFT_BOTTOM,
        FILL_VIEW_ALIGN_CENTER_TOP,
        FILL_VIEW_ALIGN_CENTER_CENTER,
        FILL_VIEW_ALIGN_CENTER_BOTTOM,
        FILL_VIEW_ALIGN_RIGHT_TOP,
        FILL_VIEW_ALIGN_RIGHT_CENTER,
        FILL_VIEW_ALIGN_RIGHT_BOTTOM;

    }
}

