/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images.tasks;

import android.content.Context;
import android.support.annotation.UiThread;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.TiledImageView;
import cz.mzk.tiledimageview.images.TilePositionInPyramid;
import cz.mzk.tiledimageview.images.TiledImageProtocol;
import cz.mzk.tiledimageview.images.tasks.DeliverMetadataTask;
import cz.mzk.tiledimageview.images.tasks.DeliverTileIntoMemoryCacheTask;
import cz.mzk.tiledimageview.images.tasks.InflateTileMemoryCache;
import cz.mzk.tiledimageview.images.tasks.InitCacheManagerTask;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;

public class TaskManager {
    public static final int MAX_TASKS_IN_POOL = 10;
    private static final Logger LOGGER = new Logger(TaskManager.class);
    private final Map<TilePositionInPyramid, DeliverTileIntoMemoryCacheTask> mDeliverTileTasks = new HashMap<TilePositionInPyramid, DeliverTileIntoMemoryCacheTask>();
    private DeliverMetadataTask mDeliverMetadataTask;
    private InflateTileMemoryCache mInflateTileMemoryCacheTask;
    private int lastITileMemoryCacheInflatedSize = 0;

    @UiThread
    public static void enqueueCacheManagerInitialization(Context context, boolean diskCacheEnabled, boolean clearDiskCache, long tileDiskCacheBytes, TaskListener listener) {
        InitCacheManagerTask task = new InitCacheManagerTask(context, diskCacheEnabled, clearDiskCache, tileDiskCacheBytes, listener);
        try {
            LOGGER.i("enqueuing init-cache-manager task");
            task.executeConcurrentIfPossible(new Void[0]);
        }
        catch (RejectedExecutionException e) {
            LOGGER.w("init-cache-manager task task: to many threads in execution pool");
            listener.onCanceled();
        }
    }

    @UiThread
    public void enqueueMetadataDelivery(TiledImageProtocol protocol, String metadataUrl, String cacheKey, TiledImageView.MetadataInitializationSuccessListener successListener, TiledImageView.MetadataInitializationListener listener) {
        if (this.mDeliverMetadataTask == null) {
            LOGGER.i("enqueuing deliver-metadata task");
            this.mDeliverMetadataTask = new DeliverMetadataTask(protocol, metadataUrl, cacheKey, listener, successListener, new TaskListener(){

                @Override
                public void onFinished(Object ... data) {
                    TaskManager.this.mDeliverMetadataTask = null;
                    LOGGER.d("deliver-metadata task finished");
                }

                @Override
                public void onCanceled() {
                    TaskManager.this.mDeliverMetadataTask = null;
                    LOGGER.d("deliver-metadata task canceled");
                }
            });
            try {
                this.mDeliverMetadataTask.executeConcurrentIfPossible(new Void[0]);
            }
            catch (RejectedExecutionException e) {
                LOGGER.d("to many threads in execution pool");
                this.mDeliverMetadataTask = null;
                listener.onCannotExecuteMetadataInitialization(metadataUrl);
            }
        } else {
            LOGGER.d("ignoring deliver-metadata task - already in queue");
        }
    }

    @UiThread
    public void enqueueTileDeliveryIntoMemoryCache(final TilePositionInPyramid tilePosition, final String tileImageUrl, String cacheKey, TiledImageView.TileDownloadSuccessListener successListener, TiledImageView.TileDownloadErrorListener errorListener) {
        if (this.mDeliverTileTasks.size() < 10) {
            if (!this.mDeliverTileTasks.containsKey(tilePosition)) {
                LOGGER.i(String.format("enqueuing deliver-tile-into-memory-cache task: %s, (total %d)", tileImageUrl, this.mDeliverTileTasks.size() + 1));
                DeliverTileIntoMemoryCacheTask task = new DeliverTileIntoMemoryCacheTask(tileImageUrl, cacheKey, successListener, errorListener, new TaskListener(){

                    @Override
                    public void onFinished(Object ... data) {
                        LOGGER.d(String.format("deliver-tile-into-memory-cache task finished: %s", tileImageUrl));
                        TaskManager.this.mDeliverTileTasks.remove(tilePosition);
                    }

                    @Override
                    public void onCanceled() {
                        LOGGER.d(String.format("deliver-tile-into-memory-cache task canceled: %s", tileImageUrl));
                        TaskManager.this.mDeliverTileTasks.remove(tilePosition);
                    }
                });
                this.mDeliverTileTasks.put(tilePosition, task);
                try {
                    task.executeConcurrentIfPossible(new Void[0]);
                }
                catch (RejectedExecutionException e) {
                    LOGGER.w("deliver-tile-into-memory-cache task: to many threads in execution pool");
                    this.mDeliverTileTasks.remove(tilePosition);
                }
            } else {
                LOGGER.d(String.format("ignoring tile-download task for '%s' (already in queue)", tileImageUrl));
            }
        } else {
            LOGGER.d(String.format("ignoring tile-download task for '%s' (queue full - %d items)", tileImageUrl, this.mDeliverTileTasks.size()));
        }
    }

    @UiThread
    public void cancelAllTasks() {
        LOGGER.d("canceling all tasks");
        if (this.mDeliverMetadataTask != null) {
            this.mDeliverMetadataTask.cancel(false);
        }
        if (this.mInflateTileMemoryCacheTask != null) {
            this.mInflateTileMemoryCacheTask.cancel(false);
        }
        for (DeliverTileIntoMemoryCacheTask task : this.mDeliverTileTasks.values()) {
            task.cancel(false);
        }
    }

    @UiThread
    public boolean cancelTileDelivery(TilePositionInPyramid tilePositionInPyramid) {
        DeliverTileIntoMemoryCacheTask task = this.mDeliverTileTasks.get(tilePositionInPyramid);
        if (task != null) {
            task.cancel(false);
            return true;
        }
        return false;
    }

    @UiThread
    public Set<TilePositionInPyramid> getIdsOfAllTileDeliveryTasks() {
        return this.mDeliverTileTasks.keySet();
    }

    public void enqueueTilesMemoryCacheInflation(final int newMaxSize) {
        if (this.lastITileMemoryCacheInflatedSize < newMaxSize && this.mInflateTileMemoryCacheTask == null) {
            InflateTileMemoryCache task;
            LOGGER.i(String.format("enqueuing inflate-tiles-memory-cache task (oldSize=%d,newSize=%d)", this.lastITileMemoryCacheInflatedSize, newMaxSize));
            this.mInflateTileMemoryCacheTask = task = new InflateTileMemoryCache(newMaxSize, new TaskListener(){

                @Override
                public void onFinished(Object ... data) {
                    TaskManager.this.lastITileMemoryCacheInflatedSize = newMaxSize;
                    TaskManager.this.mInflateTileMemoryCacheTask = null;
                }

                @Override
                public void onCanceled() {
                    TaskManager.this.mInflateTileMemoryCacheTask = null;
                }
            });
            try {
                task.executeConcurrentIfPossible(new Void[0]);
            }
            catch (RejectedExecutionException e) {
                LOGGER.d("to many threads in execution pool");
                this.mInflateTileMemoryCacheTask = null;
            }
        }
    }

    public static interface TaskListener {
        @UiThread
        public void onFinished(Object ... var1);

        public void onCanceled();
    }
}

