/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.gestures;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.PointD;
import cz.mzk.tiledimageview.TiledImageViewApi;
import cz.mzk.tiledimageview.VectorD;
import cz.mzk.tiledimageview.dev.DevTools;
import cz.mzk.tiledimageview.gestures.DoubletapZoomHandler;
import cz.mzk.tiledimageview.gestures.DragShiftHandler;
import cz.mzk.tiledimageview.gestures.FlingShiftHandler;
import cz.mzk.tiledimageview.gestures.PinchGestureDetector;
import cz.mzk.tiledimageview.gestures.PinchZoomHandler;

public class MyGestureListener
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
PinchGestureDetector.OnScaleGestureListener {
    private static final Logger LOGGER = new Logger(MyGestureListener.class);
    private final PinchGestureDetector mScaleGestureDetector;
    private final GestureDetector mGestureDetector;
    private final TiledImageViewApi mImageViewApi;
    private final PinchZoomHandler mPinchZoomHandler;
    private final DoubletapZoomHandler mDoubletapZoomHandler;
    private final DragShiftHandler mDragShiftHandler;
    private final FlingShiftHandler mFlingShiftHandler;

    public MyGestureListener(Context context, TiledImageViewApi imageViewApi, DevTools devTools) {
        this.mImageViewApi = imageViewApi;
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)this);
        this.mScaleGestureDetector = new PinchGestureDetector(this);
        this.mPinchZoomHandler = new PinchZoomHandler(imageViewApi, devTools);
        this.mDoubletapZoomHandler = new DoubletapZoomHandler(imageViewApi, devTools);
        this.mDragShiftHandler = new DragShiftHandler(imageViewApi, devTools);
        this.mFlingShiftHandler = new FlingShiftHandler(imageViewApi, devTools);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mScaleGestureDetector.onTouchEvent(event);
        this.mGestureDetector.onTouchEvent(event);
        return true;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        if (this.mDoubletapZoomHandler.getState() == DoubletapZoomHandler.State.ZOOMING) {
            this.mDoubletapZoomHandler.stopAnimation();
        }
        if (this.mFlingShiftHandler.getmState() == FlingShiftHandler.State.SHIFTING) {
            this.mFlingShiftHandler.stopAnimation();
        }
        if (this.mImageViewApi.getSingleTapListener() != null) {
            this.mImageViewApi.getSingleTapListener().onSingleTap(e.getX(), e.getY(), this.mImageViewApi.getVisibleImageAreaInCanvas());
        }
        return false;
    }

    public boolean onDoubleTap(MotionEvent e) {
        if (this.mPinchZoomHandler.getmState() != PinchZoomHandler.State.PINCHING) {
            if (this.mDoubletapZoomHandler.getState() == DoubletapZoomHandler.State.ZOOMING) {
                this.mDoubletapZoomHandler.stopAnimation();
            }
            if (this.mFlingShiftHandler.getmState() == FlingShiftHandler.State.SHIFTING) {
                this.mFlingShiftHandler.stopAnimation();
            }
            this.mDoubletapZoomHandler.startZooming(new PointD(e.getX(), e.getY()));
        }
        return false;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.mPinchZoomHandler.getmState() != PinchZoomHandler.State.PINCHING) {
            if (this.mDoubletapZoomHandler.getState() == DoubletapZoomHandler.State.ZOOMING) {
                this.mDoubletapZoomHandler.stopAnimation();
            }
            if (this.mFlingShiftHandler.getmState() == FlingShiftHandler.State.SHIFTING) {
                this.mFlingShiftHandler.stopAnimation();
            }
            this.mDragShiftHandler.drag(-distanceX, -distanceY);
        }
        return false;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (this.mPinchZoomHandler.getmState() != PinchZoomHandler.State.PINCHING) {
            if (this.mDoubletapZoomHandler.getState() == DoubletapZoomHandler.State.ZOOMING) {
                this.mDoubletapZoomHandler.stopAnimation();
            }
            if (this.mFlingShiftHandler.getmState() == FlingShiftHandler.State.SHIFTING) {
                this.mFlingShiftHandler.stopAnimation();
            }
            this.mFlingShiftHandler.fling(e2.getX(), e2.getY(), -velocityX, -velocityY);
        }
        return false;
    }

    @Override
    public boolean onScale(PinchGestureDetector detector) {
        PointD focus = new PointD(detector.getmFocusX(), detector.getmFocusY());
        double span = detector.getCurrentSpan();
        this.mPinchZoomHandler.zoom(focus, span);
        return false;
    }

    @Override
    public boolean onScaleBegin(PinchGestureDetector detector) {
        if (this.mDoubletapZoomHandler.getState() == DoubletapZoomHandler.State.ZOOMING) {
            this.mDoubletapZoomHandler.stopAnimation();
        }
        if (this.mFlingShiftHandler.getmState() == FlingShiftHandler.State.SHIFTING) {
            this.mFlingShiftHandler.stopAnimation();
        }
        this.mPinchZoomHandler.startZooming(detector.getCurrentSpan(), new PointD(detector.getmFocusX(), detector.getmFocusY()));
        return false;
    }

    @Override
    public void onScaleEnd(PinchGestureDetector detector) {
        LOGGER.d("onScaleEnd");
        this.mPinchZoomHandler.finishZooming();
    }

    public void stopAllAnimations() {
        if (this.mDoubletapZoomHandler.getState() == DoubletapZoomHandler.State.ZOOMING) {
            this.mDoubletapZoomHandler.stopAnimation();
        }
        if (this.mFlingShiftHandler.getmState() == FlingShiftHandler.State.SHIFTING) {
            this.mFlingShiftHandler.stopAnimation();
        }
    }

    public void reset() {
        this.mDragShiftHandler.reset();
        this.mFlingShiftHandler.reset();
        this.mPinchZoomHandler.reset();
        this.mDoubletapZoomHandler.reset();
    }

    public VectorD getTotalShift() {
        VectorD swipeShift = this.mDragShiftHandler.getShift();
        VectorD pinchZoomShift = this.mPinchZoomHandler.getCurrentShift();
        VectorD doubleTapZoomShift = this.mDoubletapZoomHandler.getCurrentZoomShift();
        VectorD flingShift = this.mFlingShiftHandler.getShift();
        return VectorD.sum(swipeShift, pinchZoomShift, doubleTapZoomShift, flingShift);
    }

    public double getTotalScaleFactor() {
        return this.mPinchZoomHandler.getCurrentScaleFactor() * this.mDoubletapZoomHandler.getCurrentScaleFactor();
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        return false;
    }

    public boolean onDown(MotionEvent e) {
        return false;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }

    public void onLongPress(MotionEvent e) {
    }
}

