/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.rectangles;

import android.content.Context;
import android.graphics.Rect;
import cz.mzk.tiledimageview.R;
import java.util.ArrayList;
import java.util.List;

public class FramingRectangle {
    private final Rect rect;
    private final Border border;
    private final Integer fillColorRes;

    public FramingRectangle(Rect rect, Border border, Integer fillingColorRes) {
        this.rect = rect;
        this.border = border;
        this.fillColorRes = fillingColorRes;
    }

    public FramingRectangle(int left, int top, int right, int bottom, Border border, Integer fillingColorRes) {
        this(new Rect(left, top, right, bottom), border, fillingColorRes);
    }

    public static List<FramingRectangle> getTestRectangles(Context context) {
        ArrayList<FramingRectangle> result = new ArrayList<FramingRectangle>();
        result.add(new FramingRectangle(500, 1000, 3000, 5000, new Border(R.color.tiledimageview_black_trans, 3), R.color.tiledimageview_blue_trans));
        result.add(new FramingRectangle(3300, 5500, 4000, 6000, new Border(R.color.tiledimageview_blue_trans, 5), R.color.tiledimageview_green_trans));
        result.add(new FramingRectangle(2500, 300, 3500, 500, new Border(R.color.tiledimageview_blue, 2), R.color.tiledimageview_blue_trans));
        result.add(new FramingRectangle(1111, 775, 1204, 821, new Border(R.color.tiledimageview_blue, 1), R.color.tiledimageview_blue_trans));
        result.add(new FramingRectangle(1120, 1293, 1216, 1340, new Border(R.color.tiledimageview_blue, 1), R.color.tiledimageview_blue_trans));
        return result;
    }

    public Rect getRect() {
        return this.rect;
    }

    public Border getBorder() {
        return this.border;
    }

    public Integer getFillColorRes() {
        return this.fillColorRes;
    }

    public static class Border {
        private final int colorRes;
        private final int thicknessDp;

        public Border(int colorRes, int thicknessDp) {
            this.colorRes = colorRes;
            this.thicknessDp = thicknessDp;
        }

        public int getColorRes() {
            return this.colorRes;
        }

        public int getThicknessDp() {
            return this.thicknessDp;
        }
    }
}

