/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.dev;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.Point;
import cz.mzk.tiledimageview.PointD;
import cz.mzk.tiledimageview.R;
import cz.mzk.tiledimageview.Utils;
import cz.mzk.tiledimageview.VectorD;
import cz.mzk.tiledimageview.dev.DevPoints;
import java.util.ArrayList;
import java.util.List;

public class DevTools {
    private static final Logger LOGGER = new Logger(DevTools.class);
    private final Paint paintBlue = new Paint();
    private final Paint paintRed = new Paint();
    private final Paint paintYellow = new Paint();
    private final Paint paintGreen = new Paint();
    private final Paint paintBlack = new Paint();
    private final Paint paintWhite = new Paint();
    private final Paint paintRedTrans = new Paint();
    private final Paint paintWhiteTrans = new Paint();
    private final Paint paintYellowTrans = new Paint();
    private final Paint paintBlackTrans = new Paint();
    private final Paint paintGreenTrans = new Paint();
    private final Paint paintBlueTrans = new Paint();
    private final List<RectWithPaint> rectStackAfterPrimaryDraws = new ArrayList<RectWithPaint>();
    private Canvas mCanv;
    private PointD pinchZoomCenterInCanvas;
    private PointD pinchZoomCenterInImage;
    private PointD doubletapZoomCenterInCanvas;
    private PointD doubletapZoomCenterInImage;

    public DevTools(Context context) {
        this.paintBlue.setColor(context.getResources().getColor(R.color.tiledimageview_blue));
        this.paintRed.setColor(context.getResources().getColor(R.color.tiledimageview_red));
        this.paintYellow.setColor(context.getResources().getColor(R.color.tiledimageview_yellow));
        this.paintGreen.setColor(context.getResources().getColor(R.color.tiledimageview_green));
        this.paintBlack.setColor(context.getResources().getColor(R.color.tiledimageview_black));
        this.paintWhite.setColor(context.getResources().getColor(R.color.tiledimageview_white));
        this.paintWhiteTrans.setColor(context.getResources().getColor(R.color.tiledimageview_white_trans));
        this.paintRedTrans.setColor(context.getResources().getColor(R.color.tiledimageview_red_trans));
        this.paintYellowTrans.setColor(context.getResources().getColor(R.color.tiledimageview_yellow_trans));
        this.paintBlackTrans.setColor(context.getResources().getColor(R.color.tiledimageview_black_trans));
        this.paintGreenTrans.setColor(context.getResources().getColor(R.color.tiledimageview_green_trans));
        this.paintBlueTrans.setColor(context.getResources().getColor(R.color.tiledimageview_blue_trans));
    }

    public void setCanvas(Canvas canv) {
        this.mCanv = canv;
    }

    public void fillWholeCanvasWithColor(Paint paint) {
        Rect wholeCanvas = new Rect(0, 0, this.mCanv.getWidth(), this.mCanv.getHeight());
        this.mCanv.drawRect(wholeCanvas, paint);
    }

    public void fillRectAreaWithColor(Rect rect, Paint paint) {
        this.mCanv.drawRect(rect, paint);
    }

    public void drawPoint(PointD pointInCanvas, Paint paint, float size) {
        this.mCanv.drawCircle((float)pointInCanvas.x, (float)pointInCanvas.y, size, paint);
    }

    public void drawImageCoordPoints(DevPoints testPoints, double resizeFactor, VectorD imageShiftInCanvas) {
        this.drawImageCoordPoint(testPoints.getCenter(), resizeFactor, imageShiftInCanvas, this.paintRedTrans);
        for (Point corner : testPoints.getCorners()) {
            this.drawImageCoordPoint(corner, resizeFactor, imageShiftInCanvas, this.paintRedTrans);
        }
    }

    private void drawImageCoordPoint(Point point, double resizeFactor, VectorD imageShiftInCanvas, Paint paint) {
        int resizedAndShiftedX = (int)((double)point.x * resizeFactor + imageShiftInCanvas.x);
        int resizedAndShiftedY = (int)((double)point.y * resizeFactor + imageShiftInCanvas.y);
        this.mCanv.drawCircle((float)resizedAndShiftedX, (float)resizedAndShiftedY, 30.0f, paint);
    }

    public void setDoubletapZoomCenters(PointD zoomCenterInCanvas, PointD zoomCenterInImage) {
        this.doubletapZoomCenterInCanvas = zoomCenterInCanvas;
        this.doubletapZoomCenterInImage = zoomCenterInImage;
    }

    public void setPinchZoomCenters(PointD zoomCenterInCanvas, PointD zoomCenterInImage) {
        this.pinchZoomCenterInCanvas = zoomCenterInCanvas;
        this.pinchZoomCenterInImage = zoomCenterInImage;
    }

    public void drawDoubletapZoomCenters(double resizeFactor, VectorD totalShift) {
        if (this.doubletapZoomCenterInCanvas != null && this.doubletapZoomCenterInImage != null) {
            PointD zoomCenterInImageInCanvasCoords = Utils.toCanvasCoords(this.doubletapZoomCenterInImage, resizeFactor, totalShift);
            this.mCanv.drawLine((float)zoomCenterInImageInCanvasCoords.x, (float)zoomCenterInImageInCanvasCoords.y, (float)this.doubletapZoomCenterInCanvas.x, (float)this.doubletapZoomCenterInCanvas.y, this.paintGreenTrans);
            this.mCanv.drawCircle((float)zoomCenterInImageInCanvasCoords.x, (float)zoomCenterInImageInCanvasCoords.y, 15.0f, this.paintYellow);
            this.mCanv.drawCircle((float)this.doubletapZoomCenterInCanvas.x, (float)this.doubletapZoomCenterInCanvas.y, 12.0f, this.paintGreen);
        }
    }

    public void drawPinchZoomCenters(double resizeFactor, VectorD totalShift) {
        if (this.pinchZoomCenterInCanvas != null && this.pinchZoomCenterInImage != null) {
            PointD zoomCenterInImageInCanvasCoords = Utils.toCanvasCoords(this.pinchZoomCenterInImage, resizeFactor, totalShift);
            this.mCanv.drawLine((float)zoomCenterInImageInCanvasCoords.x, (float)zoomCenterInImageInCanvasCoords.y, (float)this.pinchZoomCenterInCanvas.x, (float)this.pinchZoomCenterInCanvas.y, this.paintBlueTrans);
            this.mCanv.drawCircle((float)zoomCenterInImageInCanvasCoords.x, (float)zoomCenterInImageInCanvasCoords.y, 15.0f, this.paintYellow);
            this.mCanv.drawCircle((float)this.pinchZoomCenterInCanvas.x, (float)this.pinchZoomCenterInCanvas.y, 12.0f, this.paintBlue);
        }
    }

    public void highlightTile(Rect rect, Paint paint) {
        this.mCanv.drawLine((float)rect.left, (float)rect.top, (float)rect.left, (float)rect.bottom, paint);
        this.mCanv.drawLine((float)rect.right, (float)rect.top, (float)rect.right, (float)rect.bottom, paint);
        this.mCanv.drawLine((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.top, paint);
        this.mCanv.drawLine((float)rect.left, (float)rect.bottom, (float)rect.right, (float)rect.bottom, paint);
        this.mCanv.drawLine((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, paint);
        this.mCanv.drawLine((float)rect.right, (float)rect.top, (float)rect.left, (float)rect.bottom, paint);
        int centerX = (int)((double)rect.left + (double)(rect.right - rect.left) / 2.0);
        int centerY = (int)((double)rect.top + (double)(rect.bottom - rect.top) / 2.0);
        this.mCanv.drawCircle((float)centerX, (float)centerY, 7.0f, paint);
    }

    public Paint getPaintBlue() {
        return this.paintBlue;
    }

    public Paint getPaintRed() {
        return this.paintRed;
    }

    public Paint getPaintYellow() {
        return this.paintYellow;
    }

    public Paint getPaintGreen() {
        return this.paintGreen;
    }

    public Paint getPaintBlack() {
        return this.paintBlack;
    }

    public Paint getPaintWhite() {
        return this.paintWhite;
    }

    public Paint getPaintWhiteTrans() {
        return this.paintWhiteTrans;
    }

    public Paint getPaintRedTrans() {
        return this.paintRedTrans;
    }

    public Paint getPaintYellowTrans() {
        return this.paintYellowTrans;
    }

    public Paint getPaintBlackTrans() {
        return this.paintBlackTrans;
    }

    public Paint getPaintGreenTrans() {
        return this.paintGreenTrans;
    }

    public Paint getPaintBlueTrans() {
        return this.paintBlueTrans;
    }

    public void clearRectStack() {
        this.rectStackAfterPrimaryDraws.clear();
    }

    public void addToRectStack(RectWithPaint rect) {
        this.rectStackAfterPrimaryDraws.add(rect);
    }

    public void drawTileRectStack() {
        for (RectWithPaint rect : this.rectStackAfterPrimaryDraws) {
            this.fillRectAreaWithColor(rect.getRect(), rect.getPaint());
        }
    }

    public static class RectWithPaint {
        private final Rect rect;
        private final Paint paint;

        public RectWithPaint(Rect rect, Paint paint) {
            this.rect = rect;
            this.paint = paint;
        }

        public Rect getRect() {
            return this.rect;
        }

        public Paint getPaint() {
            return this.paint;
        }
    }
}

