/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images.cache;

import android.content.Context;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.images.cache.AbstractCache;
import cz.mzk.tiledimageview.images.cache.DiskLruCache;

public class MetadataCache
extends AbstractCache<String> {
    public static final String DISK_CACHE_SUBDIR = "imageProperties";
    public static final int DISK_CACHE_SIZE_BYTES = 0xA00000;
    public static final int MEMORY_CACHE_SIZE_ITEMS = 100;

    public MetadataCache(Context context, boolean diskCacheEnabled, boolean clearDiskCache) {
        super(context, new Logger(MetadataCache.class), 100, diskCacheEnabled, DISK_CACHE_SUBDIR, 0xA00000L, clearDiskCache);
    }

    @Override
    String getItem(DiskLruCache diskCache, String key) throws DiskLruCache.DiskLruCacheException {
        DiskLruCache.Snapshot snapshot = diskCache.get(key);
        if (snapshot != null) {
            String result = snapshot.getString(0);
            if (result == null) {
                this.mLogger.w("item from disk cache was null, removing record");
                diskCache.remove(key);
                return null;
            }
            return result;
        }
        return null;
    }

    @Override
    void storeItem(DiskLruCache diskCache, String key, String matadata) throws DiskLruCache.DiskLruCacheException {
        diskCache.storeString(0, key, matadata);
    }
}

