/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images.cache;

import cz.mzk.tiledimageview.Logger;
import java.io.File;

public class DiskUtils {
    private static final Logger LOGGER = new Logger(DiskUtils.class);

    public static boolean deleteDirContent(File file) {
        if (file == null) {
            throw new NullPointerException("file is null");
        }
        if (!file.exists()) {
            LOGGER.w("file doesn't exist: " + file.getAbsolutePath());
            return false;
        }
        if (!file.isDirectory()) {
            LOGGER.w("not directory: " + file.getAbsolutePath());
            return false;
        }
        File[] filesInDir = file.listFiles();
        if (filesInDir != null && filesInDir.length > 0) {
            for (File fileInDir : filesInDir) {
                if (DiskUtils.deleteWithContent(fileInDir)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean deleteWithContent(File file) {
        boolean deleted;
        if (file == null) {
            throw new NullPointerException("file is null");
        }
        if (!file.exists()) {
            LOGGER.w("doesn't exist: " + file.getAbsolutePath());
            return false;
        }
        if (file.isFile()) {
            boolean deleted2 = file.delete();
            if (!deleted2) {
                LOGGER.w("failed to delete file " + file.getAbsolutePath());
            }
            return deleted2;
        }
        if (!file.isDirectory()) {
            LOGGER.w("not file nor directory: " + file.getAbsolutePath());
            return false;
        }
        File[] filesInDir = file.listFiles();
        if (filesInDir != null && filesInDir.length > 0) {
            for (File fileInDir : filesInDir) {
                if (DiskUtils.deleteWithContent(fileInDir)) continue;
                return false;
            }
        }
        if (!(deleted = file.delete())) {
            LOGGER.w("failed to delete directory " + file.getAbsolutePath());
        }
        return deleted;
    }
}

