/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images.cache;

import android.content.Context;
import android.content.pm.PackageManager;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.Utils;
import cz.mzk.tiledimageview.images.cache.Cache;
import cz.mzk.tiledimageview.images.cache.DiskLruCache;
import cz.mzk.tiledimageview.images.cache.DiskUtils;
import cz.mzk.tiledimageview.images.cache.InflatableLruCache;
import java.io.File;
import java.io.IOException;

public abstract class AbstractCache<Item>
implements Cache<Item> {
    protected final Logger mLogger;
    private final InflatableLruCache<String, Item> mMemoryCache;
    private Object mMemoryCacheLock = new Object();
    private DiskLruCache mDiskCache = null;

    public AbstractCache(Context context, Logger logger, int memoryCacheSizeItems, boolean diskCacheEnabled, String diskCacheSubdir, long diskCacheSizeBytes, boolean clearDiskCache) {
        this.mLogger = logger;
        this.mMemoryCache = this.initMemoryCache(memoryCacheSizeItems);
        this.mDiskCache = diskCacheEnabled ? this.initDiskCache(context, diskCacheSubdir, diskCacheSizeBytes, clearDiskCache) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InflatableLruCache<String, Item> initMemoryCache(int sizeItems) {
        InflatableLruCache result;
        Object object = this.mMemoryCacheLock;
        synchronized (object) {
            this.mLogger.v("assumed memory-cache lock (initialization): " + Thread.currentThread().toString());
            result = new InflatableLruCache(sizeItems, this.mLogger);
            this.mLogger.d("in-memory lru cache allocated for " + sizeItems + " items");
        }
        this.mLogger.v("released memory-cache lock (initialization): " + Thread.currentThread().toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Item getItemFromMemoryCache(String key) {
        Item result;
        Object object = this.mMemoryCacheLock;
        synchronized (object) {
            this.mLogger.v("assumed memory-cache lock (get): " + Thread.currentThread().toString());
            result = this.mMemoryCache.get(key);
        }
        this.mLogger.v("released memory-cache lock (get): " + Thread.currentThread().toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeItemToMemoryCache(String key, Item item) {
        Object object = this.mMemoryCacheLock;
        synchronized (object) {
            this.mLogger.v("assumed memory-cache lock (store): " + Thread.currentThread().toString());
            if (this.mMemoryCache.get(key) == null) {
                this.mLogger.d("storing to memory cache: " + key);
                this.mMemoryCache.put(key, item);
            } else {
                this.mLogger.d("already in memory cache: " + key);
            }
        }
        this.mLogger.v("released memory-cache lock (store): " + Thread.currentThread().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increasMemoryCacheSize(int newMaxItems) {
        Object object = this.mMemoryCacheLock;
        synchronized (object) {
            this.mMemoryCache.inflate(newMaxItems);
        }
    }

    private DiskLruCache initDiskCache(Context context, String subdir, long sizeBytes, boolean clearCache) {
        try {
            File cacheDir = this.getDiskCacheDir(context, subdir);
            int appVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
            if (cacheDir.exists()) {
                if (clearCache) {
                    this.mLogger.i("clearing disk cache");
                    boolean cleared = DiskUtils.deleteDirContent(cacheDir);
                    if (!cleared) {
                        this.mLogger.w("failed to delete content of " + cacheDir.getAbsolutePath() + ", disabling disk cache");
                        return null;
                    }
                }
            } else {
                this.mLogger.i("creating disk cache dir " + cacheDir);
                boolean created = cacheDir.mkdir();
                if (!created) {
                    this.mLogger.w("failed to create disk cache dir " + cacheDir.getAbsolutePath() + ", disabling disk cache");
                    return null;
                }
            }
            this.mLogger.d("disk cache dir: " + cacheDir.getAbsolutePath());
            DiskLruCache result = DiskLruCache.open(cacheDir, appVersion, 1, sizeBytes);
            this.mLogger.i("disk cache initialized; size: " + Utils.formatBytes(sizeBytes));
            return result;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (DiskLruCache.DiskLruCacheException e) {
            this.mLogger.w("error initializing disk cache, disabling");
            return null;
        }
    }

    private File getDiskCacheDir(Context context, String subdir) {
        String cacheDirPath = context.getCacheDir().getPath();
        return new File(cacheDirPath + File.separator + subdir);
    }

    @Override
    public boolean isDiskCacheEnabled() {
        return this.mDiskCache != null;
    }

    @Override
    public boolean isItemInDiskCache(String key) {
        if (this.mDiskCache != null) {
            try {
                return this.mDiskCache.containsReadable(key);
            }
            catch (IOException e) {
                this.mLogger.v("isItemInDiskCache error: " + key, e);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.mDiskCache.flush();
        }
        catch (DiskLruCache.DiskLruCacheException e) {
            this.mLogger.e("Error flushing disk cache");
        }
        finally {
            try {
                this.mDiskCache.close();
            }
            catch (IOException e) {
                this.mLogger.e("Error closing disk cache");
            }
        }
    }

    @Override
    public Item getItemFromDiskCache(String key) {
        if (this.mDiskCache != null) {
            try {
                return this.getItem(this.mDiskCache, key);
            }
            catch (DiskLruCache.DiskLruCacheException e) {
                this.mLogger.w("error loading from disk cache: " + key, e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void storeItemToDiskCache(String key, Item item) {
        if (this.mDiskCache != null) {
            try {
                DiskLruCache.Snapshot fromDiskCache = this.mDiskCache.get(key);
                if (fromDiskCache != null) {
                    this.mLogger.d("already in disk cache: " + key);
                } else {
                    this.mLogger.d("storing into disk cache: " + key);
                    this.storeItem(this.mDiskCache, key, item);
                }
            }
            catch (DiskLruCache.DiskLruCacheException e) {
                this.mLogger.e("failed to store into disk cache: " + key, e);
            }
        }
    }

    abstract Item getItem(DiskLruCache var1, String var2) throws DiskLruCache.DiskLruCacheException;

    abstract void storeItem(DiskLruCache var1, String var2, Item var3) throws DiskLruCache.DiskLruCacheException;
}

