/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.gestures;

import android.annotation.SuppressLint;
import android.view.MotionEvent;
import cz.mzk.tiledimageview.Logger;

public class PinchGestureDetector {
    private static final Logger LOGGER = new Logger(PinchGestureDetector.class);
    private final OnScaleGestureListener listener;
    private double mFocusX;
    private double mFocusY;
    private double mSpan;

    public PinchGestureDetector(OnScaleGestureListener listener) {
        this.listener = listener;
    }

    @SuppressLint(value={"NewApi"})
    public void onTouchEvent(MotionEvent event) {
        int actionMasked = event.getActionMasked();
        switch (actionMasked) {
            case 3: {
                break;
            }
            case 5: {
                if (event.getPointerCount() != 2) break;
                this.mSpan = this.computeSpan(event.getX(0), event.getY(0), event.getX(1), event.getY(1));
                this.mFocusX = (double)(event.getX(0) + event.getX(1)) * 0.5;
                this.mFocusY = (double)(event.getY(0) + event.getY(1)) * 0.5;
                this.listener.onScaleBegin(this);
                break;
            }
            case 6: {
                if (event.getPointerCount() != 2) break;
                this.listener.onScaleEnd(this);
                break;
            }
            case 2: {
                if (event.getPointerCount() != 2) break;
                this.mSpan = this.computeSpan(event.getX(0), event.getY(0), event.getX(1), event.getY(1));
                this.mFocusX = (double)(event.getX(0) + event.getX(1)) * 0.5;
                this.mFocusY = (double)(event.getY(0) + event.getY(1)) * 0.5;
                this.listener.onScale(this);
            }
        }
    }

    public double getmFocusX() {
        return this.mFocusX;
    }

    public double getmFocusY() {
        return this.mFocusY;
    }

    public double getCurrentSpan() {
        return this.mSpan;
    }

    private double computeSpan(float firstX, float firstY, float secondX, float secondY) {
        double diffX = firstX - secondX;
        double diffY = firstY - secondY;
        return Math.sqrt(diffX * diffX + diffY * diffY);
    }

    public static interface OnScaleGestureListener {
        public boolean onScale(PinchGestureDetector var1);

        public boolean onScaleBegin(PinchGestureDetector var1);

        public void onScaleEnd(PinchGestureDetector var1);
    }
}

