/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.rectangles;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.Utils;
import cz.mzk.tiledimageview.VectorD;
import cz.mzk.tiledimageview.rectangles.FramingRectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FramingRectangleDrawer {
    private static final Logger LOGGER = new Logger(FramingRectangleDrawer.class);
    private final Context mContext;
    private Canvas mCanv;
    private List<FramingRectangle> mFramingRectangles;
    private Map<Integer, Paint> mBorderPaintMap;
    private Map<Integer, Paint> mFillingPaintMap;

    public FramingRectangleDrawer(Context context) {
        this.mContext = context;
    }

    private void initPaints() {
        if (this.mFramingRectangles != null) {
            for (FramingRectangle rect : this.mFramingRectangles) {
                FramingRectangle.Border border;
                Integer fillColor = rect.getFillColorRes();
                if (fillColor != null) {
                    this.initFillingPaintIfNeeded(fillColor);
                }
                if ((border = rect.getBorder()) == null) continue;
                this.initBorderPaintIfNeeded(border.getColorRes(), border.getThicknessDp());
            }
        }
    }

    private void initFillingPaintIfNeeded(Integer color2) {
        Paint found = this.mFillingPaintMap.get(color2);
        if (found == null) {
            Paint paint = new Paint();
            paint.setColor(this.mContext.getResources().getColor(color2.intValue()));
            this.mFillingPaintMap.put(color2, paint);
        }
    }

    private void initBorderPaintIfNeeded(Integer color2, int thicknessDp) {
        Paint found = this.mBorderPaintMap.get(color2);
        if (found == null) {
            Paint paint = new Paint();
            paint.setColor(this.mContext.getResources().getColor(color2.intValue()));
            paint.setStrokeWidth((float)Utils.dpToPx(thicknessDp));
            this.mBorderPaintMap.put(color2, paint);
        }
    }

    public void setCanvas(Canvas canv) {
        this.mCanv = canv;
    }

    public void setFrameRectangles(List<FramingRectangle> framingRectangles) {
        this.mFramingRectangles = framingRectangles;
        this.mBorderPaintMap = new HashMap<Integer, Paint>();
        this.mFillingPaintMap = new HashMap<Integer, Paint>();
        this.initPaints();
    }

    public void draw(double totalScaleFactor, VectorD totalShift) {
        if (this.mCanv == null) {
            LOGGER.w("draw() called, but canvas not initialized yet");
        } else if (this.mFramingRectangles != null) {
            for (FramingRectangle rect : this.mFramingRectangles) {
                this.drawRect(rect, totalScaleFactor, totalShift);
            }
        }
    }

    private void drawRect(FramingRectangle framingRect, double totalScaleFactor, VectorD totalShift) {
        Rect rectInCanvasCoords = Utils.toCanvasCoords(framingRect.getRect(), totalScaleFactor, totalShift);
        if (framingRect.getFillColorRes() != null) {
            Paint fillPaint = this.mFillingPaintMap.get(framingRect.getFillColorRes());
            this.mCanv.drawRect(rectInCanvasCoords, fillPaint);
        }
        if (framingRect.getBorder() != null) {
            Paint borderPaint = this.mBorderPaintMap.get(framingRect.getBorder().getColorRes());
            this.mCanv.drawLine((float)rectInCanvasCoords.left, (float)rectInCanvasCoords.top, (float)rectInCanvasCoords.left, (float)rectInCanvasCoords.bottom, borderPaint);
            this.mCanv.drawLine((float)rectInCanvasCoords.right, (float)rectInCanvasCoords.top, (float)rectInCanvasCoords.right, (float)rectInCanvasCoords.bottom, borderPaint);
            this.mCanv.drawLine((float)rectInCanvasCoords.left, (float)rectInCanvasCoords.top, (float)rectInCanvasCoords.right, (float)rectInCanvasCoords.top, borderPaint);
            this.mCanv.drawLine((float)rectInCanvasCoords.left, (float)rectInCanvasCoords.bottom, (float)rectInCanvasCoords.right, (float)rectInCanvasCoords.bottom, borderPaint);
        }
    }
}

