/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images.tasks;

import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.TiledImageView;
import cz.mzk.tiledimageview.images.Downloader;
import cz.mzk.tiledimageview.images.TiledImageProtocol;
import cz.mzk.tiledimageview.images.cache.CacheManager;
import cz.mzk.tiledimageview.images.cache.MetadataCache;
import cz.mzk.tiledimageview.images.exceptions.ImageServerResponseException;
import cz.mzk.tiledimageview.images.exceptions.InvalidDataException;
import cz.mzk.tiledimageview.images.exceptions.OtherIOException;
import cz.mzk.tiledimageview.images.exceptions.TooManyRedirectionsException;
import cz.mzk.tiledimageview.images.metadata.ImageMetadata;
import cz.mzk.tiledimageview.images.tasks.ConcurrentAsyncTask;
import cz.mzk.tiledimageview.images.tasks.TaskManager;
import cz.mzk.tiledimageview.images.zoomify.ZoomifyMetadataParser;

public class DeliverMetadataTask
extends ConcurrentAsyncTask<Void, Void, ImageMetadata> {
    private static final Logger LOGGER = new Logger(DeliverMetadataTask.class);
    private final TiledImageView.MetadataInitializationListener mListener;
    private final TiledImageView.MetadataInitializationSuccessListener mSuccessListener;
    private final TaskManager.TaskListener mTaskManagerListener;
    private final String mMetadataUrl;
    private final TiledImageProtocol mProtocol;
    private final String mCacheKey;
    private TooManyRedirectionsException mTooManyRedirectionsException;
    private ImageServerResponseException mImageServerResponseException;
    private InvalidDataException mInvalidXmlException;
    private OtherIOException mOtherIoException;

    public DeliverMetadataTask(TiledImageProtocol protocol, String metadataUrl, String cacheKey, TiledImageView.MetadataInitializationListener listener, TiledImageView.MetadataInitializationSuccessListener successListener, TaskManager.TaskListener taskManagerListener) {
        this.mProtocol = protocol;
        this.mMetadataUrl = metadataUrl;
        this.mCacheKey = cacheKey;
        this.mListener = listener;
        this.mSuccessListener = successListener;
        this.mTaskManagerListener = taskManagerListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ImageMetadata doInBackground(Void ... params) {
        if (this.isCancelled()) return null;
        MetadataCache tileCache = CacheManager.getMetadataCache();
        boolean diskCacheEnabled = tileCache.isDiskCacheEnabled();
        if (!diskCacheEnabled) return this.fetchFromNetAndSave(tileCache, false);
        boolean inDiskCache = tileCache.isItemInDiskCache(this.mCacheKey);
        LOGGER.d("is in disk cache: " + inDiskCache);
        if (this.isCancelled()) return null;
        if (!inDiskCache) return this.fetchFromNetAndSave(tileCache, diskCacheEnabled);
        String fromDiskCache = (String)tileCache.getItemFromDiskCache(this.mCacheKey);
        if (this.isCancelled()) return null;
        if (fromDiskCache != null) {
            LOGGER.d("disk cache returned metadata");
            tileCache.storeItemToMemoryCache(this.mCacheKey, fromDiskCache);
            LOGGER.d("metadata stored into memory cache");
            return this.parse(fromDiskCache);
        }
        LOGGER.w("disk cache returned null");
        return null;
    }

    private ImageMetadata fetchFromNetAndSave(MetadataCache metadataCache, boolean diskCacheEnabled) {
        String metadataStr = this.downloadMetadata();
        if (metadataStr != null) {
            LOGGER.d("fetched from net");
            if (!this.isCancelled()) {
                ImageMetadata metadata = this.parse(metadataStr);
                if (!this.isCancelled()) {
                    metadataCache.storeItemToMemoryCache(this.mCacheKey, metadataStr);
                    LOGGER.d("metadata stored into memory cache");
                }
                if (!this.isCancelled() && diskCacheEnabled) {
                    metadataCache.storeItemToDiskCache(this.mCacheKey, metadataStr);
                    LOGGER.d("metadata stored into disk cache");
                }
                if (!this.isCancelled()) {
                    return metadata;
                }
            }
        } else {
            LOGGER.d("fetched from net but null");
        }
        return null;
    }

    private ImageMetadata parse(String metadataStr) {
        switch (this.mProtocol) {
            case ZOOMIFY: {
                try {
                    return new ZoomifyMetadataParser().parse(metadataStr, this.mMetadataUrl);
                }
                catch (InvalidDataException e) {
                    this.mInvalidXmlException = e;
                    break;
                }
                catch (OtherIOException e) {
                    this.mOtherIoException = e;
                }
            }
        }
        return null;
    }

    private String downloadMetadata() {
        try {
            return Downloader.downloadMetadata(this.mMetadataUrl);
        }
        catch (TooManyRedirectionsException e) {
            this.mTooManyRedirectionsException = e;
        }
        catch (ImageServerResponseException e) {
            this.mImageServerResponseException = e;
        }
        catch (OtherIOException e) {
            this.mOtherIoException = e;
        }
        return null;
    }

    protected void onPostExecute(ImageMetadata result) {
        if (this.mTaskManagerListener != null) {
            this.mTaskManagerListener.onFinished(new Object[0]);
        }
        if (result != null) {
            if (this.mSuccessListener != null) {
                this.mSuccessListener.onMetadataFetched(result);
            }
            if (this.mListener != null) {
                this.mListener.onMetadataInitialized();
            }
        } else if (this.mListener != null) {
            if (this.mTooManyRedirectionsException != null) {
                this.mListener.onMetadataRedirectionLoop(this.mTooManyRedirectionsException.getUrl(), this.mTooManyRedirectionsException.getRedirections());
            } else if (this.mImageServerResponseException != null) {
                this.mListener.onMetadataUnhandableResponseCode(this.mImageServerResponseException.getUrl(), this.mImageServerResponseException.getErrorCode());
            } else if (this.mInvalidXmlException != null) {
                this.mListener.onMetadataInvalidData(this.mInvalidXmlException.getUrl(), this.mInvalidXmlException.getMessage());
            } else if (this.mOtherIoException != null) {
                this.mListener.onMetadataDataTransferError(this.mOtherIoException.getUrl(), this.mOtherIoException.getMessage());
            }
        }
    }

    protected void onCancelled(ImageMetadata result) {
        if (this.mTaskManagerListener != null) {
            this.mTaskManagerListener.onCanceled();
        }
    }
}

