/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images.cache;

import android.os.Build;
import android.util.LruCache;
import cz.mzk.tiledimageview.Logger;
import java.util.Map;

public class InflatableLruCache<Key, Item> {
    private final Logger mLogger;
    private LruCache<Key, Item> mCache;

    public InflatableLruCache(int size, Logger logger) {
        this.mLogger = logger;
        this.mCache = new LruCache(size);
    }

    public void inflate(int newMaxSize) {
        int currentSize = this.mCache.maxSize();
        if (newMaxSize > currentSize) {
            this.mLogger.d("Increasing cache max size " + currentSize + " -> " + newMaxSize + " items");
            if (Build.VERSION.SDK_INT >= 21) {
                this.mCache.resize(newMaxSize);
            } else {
                Map snapshot = this.mCache.snapshot();
                this.mCache = new LruCache(newMaxSize);
                for (Object key : snapshot.keySet()) {
                    this.mCache.put(key, snapshot.get(key));
                }
            }
        }
    }

    public Item get(Key key) {
        return (Item)this.mCache.get(key);
    }

    public void put(Key key, Item item) {
        this.mCache.put(key, item);
    }
}

