/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images.cache;

import android.util.LruCache;
import cz.mzk.tiledimageview.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CacheKeyBuilder {
    private static final Logger LOGGER = new Logger(CacheKeyBuilder.class);
    private static final boolean CACHE_KEYS = true;
    private static final Object lock = new Object();
    private static final char ESCAPE_CHAR = '_';
    private static final Map<Character, Character> POSSIBLY_RESERVED_CHARS = CacheKeyBuilder.initPossiblyReservedChars();
    private static final Map<String, Character> ESCAPED_SUBSTRINGS = CacheKeyBuilder.initEscapedStrings();
    private static final LruCache<String, String> KEY_CACHE = new LruCache(50);

    private static Map<String, Character> initEscapedStrings() {
        HashMap<String, Character> map = new HashMap<String, Character>();
        map.put("ImageProperties.xml", Character.valueOf('1'));
        map.put("http://", Character.valueOf('2'));
        map.put("https://", Character.valueOf('3'));
        map.put(".jpg", Character.valueOf('4'));
        map.put("TileGroup", Character.valueOf('5'));
        return map;
    }

    private static Map<Character, Character> initPossiblyReservedChars() {
        HashMap<Character, Character> map = new HashMap<Character, Character>();
        map.put(Character.valueOf('/'), Character.valueOf('a'));
        map.put(Character.valueOf('\\'), Character.valueOf('b'));
        map.put(Character.valueOf('?'), Character.valueOf('c'));
        map.put(Character.valueOf('%'), Character.valueOf('d'));
        map.put(Character.valueOf('*'), Character.valueOf('e'));
        map.put(Character.valueOf(':'), Character.valueOf('f'));
        map.put(Character.valueOf('|'), Character.valueOf('g'));
        map.put(Character.valueOf('\"'), Character.valueOf('h'));
        map.put(Character.valueOf('<'), Character.valueOf('i'));
        map.put(Character.valueOf('>'), Character.valueOf('j'));
        map.put(Character.valueOf('.'), Character.valueOf('k'));
        map.put(Character.valueOf(':'), Character.valueOf('l'));
        map.put(Character.valueOf('('), Character.valueOf('m'));
        map.put(Character.valueOf(')'), Character.valueOf('n'));
        map.put(Character.valueOf('&'), Character.valueOf('o'));
        map.put(Character.valueOf(';'), Character.valueOf('p'));
        map.put(Character.valueOf('#'), Character.valueOf('q'));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buildKeyFromUrl(String url) {
        Object object = lock;
        synchronized (object) {
            String fromCache = (String)KEY_CACHE.get((Object)url);
            if (fromCache != null) {
                if (fromCache.length() > 127) {
                    LOGGER.w("cache key is longer then 127 characters");
                }
                return fromCache;
            }
            String escapedSubstrings = CacheKeyBuilder.escapeSubstrings(url);
            String result = CacheKeyBuilder.escapeSpecialChars(escapedSubstrings);
            KEY_CACHE.put((Object)url, (Object)result);
            if (result.length() > 127) {
                LOGGER.w("cache key is longer then 127 characters");
            }
            return result;
        }
    }

    private static String escapeSubstrings(String url) {
        Character escapCharacter = Character.valueOf('_');
        for (String substring : ESCAPED_SUBSTRINGS.keySet()) {
            String replacement = "" + escapCharacter + ESCAPED_SUBSTRINGS.get(substring);
            url = url.replace(substring, replacement);
        }
        return url;
    }

    private static String escapeSpecialChars(String url) {
        StringBuilder builder = new StringBuilder();
        Set<Character> keys = POSSIBLY_RESERVED_CHARS.keySet();
        for (int i = 0; i < url.length(); ++i) {
            char original = url.charAt(i);
            Character key = Character.valueOf(original);
            if (keys.contains(key)) {
                builder.append('_').append(POSSIBLY_RESERVED_CHARS.get(key));
                continue;
            }
            builder.append(original);
        }
        return builder.toString();
    }
}

